/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public final class EndEventProcessor
implements BpmnElementProcessor<ExecutableEndEvent> {
    private final List<EndEventBehavior> endEventBehaviors = List.of(new NoneEndEventBehavior(), new ErrorEndEventBehavior(), new MessageEndEventBehavior(), new TerminateEndEventBehavior(), new EscalationEndEventBehavior());
    private final ExpressionProcessor expressionProcessor;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnStateBehavior stateBehavior;

    public EndEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
    }

    @Override
    public Class<ExecutableEndEvent> getType() {
        return ExecutableEndEvent.class;
    }

    @Override
    public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
        this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public void onComplete(ExecutableEndEvent element, BpmnElementContext context) {
        this.eventBehaviorOf(element).onComplete(element, context);
    }

    @Override
    public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        this.eventBehaviorOf(element).onTerminate(element, terminating);
        this.incidentBehavior.resolveIncidents(terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private EndEventBehavior eventBehaviorOf(ExecutableEndEvent element) {
        return this.endEventBehaviors.stream().filter(behavior -> behavior.isSuitableForEvent(element)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This kind of end event is not supported."));
    }

    private class NoneEndEventBehavior
    implements EndEventBehavior {
        private NoneEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isNoneEndEvent();
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            BpmnElementContext completing = EndEventProcessor.this.stateTransitionBehavior.transitionToCompleting(activated);
            EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }
    }

    private class ErrorEndEventBehavior
    implements EndEventBehavior {
        private ErrorEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isErrorEndEvent();
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            this.evaluateErrorCode(element, activating).flatMap(errorCode -> EndEventProcessor.this.eventPublicationBehavior.findErrorCatchEvent((DirectBuffer)errorCode, activating)).ifRightOrLeft(catchEvent -> {
                EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
                EndEventProcessor.this.eventPublicationBehavior.throwErrorEvent((CatchEventAnalyzer.CatchEventTuple)catchEvent);
            }, failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }

        private Either<Failure, DirectBuffer> evaluateErrorCode(ExecutableEndEvent element, BpmnElementContext context) {
            ExecutableError error = element.getError();
            EnsureUtil.ensureNotNull((String)"error", (Object)error);
            if (error.getErrorCode().isPresent()) {
                return Either.right((Object)error.getErrorCode().get());
            }
            return EndEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(error.getErrorCodeExpression(), context.getElementInstanceKey());
        }
    }

    private class MessageEndEventBehavior
    implements EndEventBehavior {
        private MessageEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isMessageEventEvent();
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            EndEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> EndEventProcessor.this.jobBehavior.createNewJob(activating, element)).ifRightOrLeft(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }

        @Override
        public void onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }

        @Override
        public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
            EndEventProcessor.this.jobBehavior.cancelJob(terminating);
        }
    }

    private class TerminateEndEventBehavior
    implements EndEventBehavior {
        private TerminateEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isTerminateEndEvent();
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            BpmnElementContext completing = EndEventProcessor.this.stateTransitionBehavior.transitionToCompleting(activated);
            EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).ifRightOrLeft(completed -> {
                BpmnElementContext flowScopeContext = EndEventProcessor.this.stateBehavior.getFlowScopeContext((BpmnElementContext)completed);
                EndEventProcessor.this.stateTransitionBehavior.terminateChildInstances(flowScopeContext);
            }, failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }
    }

    private class EscalationEndEventBehavior
    implements EndEventBehavior {
        private EscalationEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isEscalationEndEvent();
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            this.evaluateEscalationCode(element, activating).ifRightOrLeft(escalationCode -> {
                BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
                boolean canBeCompleted = EndEventProcessor.this.eventPublicationBehavior.throwEscalationEvent(element.getId(), (DirectBuffer)escalationCode, activated);
                if (canBeCompleted) {
                    EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
                }
            }, failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }

        @Override
        public void onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }

        private Either<Failure, DirectBuffer> evaluateEscalationCode(ExecutableEndEvent element, BpmnElementContext context) {
            ExecutableEscalation escalation = element.getEscalation();
            EnsureUtil.ensureNotNull((String)"escalation", (Object)escalation);
            if (escalation.getEscalationCode().isPresent()) {
                return Either.right((Object)escalation.getEscalationCode().get());
            }
            return EndEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(escalation.getEscalationCodeExpression(), context.getElementInstanceKey());
        }
    }

    private static interface EndEventBehavior {
        public boolean isSuitableForEvent(ExecutableEndEvent var1);

        public void onActivate(ExecutableEndEvent var1, BpmnElementContext var2);

        default public void onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
        }

        default public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        }
    }
}

