/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;

public final class JobTimeoutTrigger
implements StreamProcessorLifecycleAware {
    public static final Duration TIME_OUT_POLLING_INTERVAL = Duration.ofSeconds(30L);
    private final JobState state;
    private boolean shouldReschedule = false;
    private ReadonlyStreamProcessorContext processingContext;
    private final Task deactivateTimedOutJobs;

    public JobTimeoutTrigger(JobState state) {
        this.state = state;
        this.deactivateTimedOutJobs = new DeactivateTimeOutJobs();
    }

    public void onRecovered(ReadonlyStreamProcessorContext processingContext) {
        this.processingContext = processingContext;
        this.shouldReschedule = true;
        this.scheduleDeactivateTimedOutJobsTask();
    }

    public void onClose() {
        this.cancelTimer();
    }

    public void onFailed() {
        this.cancelTimer();
    }

    public void onPaused() {
        this.cancelTimer();
    }

    public void onResumed() {
        if (this.shouldReschedule) {
            this.scheduleDeactivateTimedOutJobsTask();
        }
    }

    private void scheduleDeactivateTimedOutJobsTask() {
        this.processingContext.getScheduleService().runDelayed(TIME_OUT_POLLING_INTERVAL, this.deactivateTimedOutJobs);
    }

    private void cancelTimer() {
        this.shouldReschedule = false;
    }

    private final class DeactivateTimeOutJobs
    implements Task {
        private DeactivateTimeOutJobs() {
        }

        public TaskResult execute(TaskResultBuilder taskResultBuilder) {
            long now = ActorClock.currentTimeMillis();
            JobTimeoutTrigger.this.state.forEachTimedOutEntry(now, (key, record) -> taskResultBuilder.appendCommandRecord(key.longValue(), (Intent)JobIntent.TIME_OUT, (UnifiedRecordValue)record));
            if (JobTimeoutTrigger.this.shouldReschedule) {
                JobTimeoutTrigger.this.scheduleDeactivateTimedOutJobsTask();
            }
            return taskResultBuilder.build();
        }
    }
}

