/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import java.util.function.Function;

public final class DbMigrationController
implements StreamProcessorLifecycleAware {
    private DbMigrator dbMigrator;
    private final Function<MutableProcessingState, DbMigrator> migratorFactory;
    private final MutableProcessingState mutableProcessingState;

    public DbMigrationController(MutableProcessingState mutableProcessingState) {
        this(mutableProcessingState, DbMigratorImpl::new);
    }

    DbMigrationController(MutableProcessingState mutableProcessingState, Function<MutableProcessingState, DbMigrator> migratorFactory) {
        this.mutableProcessingState = mutableProcessingState;
        this.migratorFactory = migratorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        DbMigrator migrator = this.migratorFactory.apply(this.mutableProcessingState);
        DbMigrationController dbMigrationController = this;
        synchronized (dbMigrationController) {
            this.dbMigrator = migrator;
        }
        try {
            migrator.runMigrations();
        }
        finally {
            dbMigrationController = this;
            synchronized (dbMigrationController) {
                this.dbMigrator = null;
            }
        }
    }

    public void onClose() {
        this.abortMigrationIfRunning();
    }

    public void onFailed() {
        this.abortMigrationIfRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortMigrationIfRunning() {
        DbMigrationController dbMigrationController = this;
        synchronized (dbMigrationController) {
            if (this.dbMigrator != null) {
                this.dbMigrator.abort();
            }
        }
    }
}

