/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCalledDecision;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public final class BpmnDecisionBehavior {
    private final DecisionBehavior decisionBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableState variableState;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionBehavior;

    public BpmnDecisionBehavior(DecisionBehavior decisionBehavior, ProcessingState processingState, EventTriggerBehavior eventTriggerBehavior, StateWriter stateWriter, KeyGenerator keyGenerator, ExpressionProcessor expressionBehavior) {
        this.variableState = processingState.getVariableState();
        this.decisionBehavior = decisionBehavior;
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.stateWriter = stateWriter;
        this.keyGenerator = keyGenerator;
        this.expressionBehavior = expressionBehavior;
    }

    public Either<Failure, DecisionEvaluationResult> evaluateDecision(ExecutableCalledDecision element, BpmnElementContext context) {
        long scopeKey = context.getElementInstanceKey();
        Either<Failure, String> decisionIdOrFailure = this.evalDecisionIdExpression(element, scopeKey);
        if (decisionIdOrFailure.isLeft()) {
            return Either.left((Object)((Failure)decisionIdOrFailure.getLeft()));
        }
        String decisionId = (String)decisionIdOrFailure.get();
        Either<Failure, PersistedDecision> decisionOrFailure = this.decisionBehavior.findDecisionById(decisionId);
        Either drgOrFailure = decisionOrFailure.flatMap(decision -> this.decisionBehavior.findAndParseDrgByDecision((PersistedDecision)((Object)decision))).mapLeft(failure -> new Failure(failure.getMessage(), ErrorType.CALLED_DECISION_ERROR, scopeKey));
        DirectBuffer variables = this.variableState.getVariablesAsDocument(scopeKey);
        Either resultOrFailure = drgOrFailure.flatMap(drg -> {
            PersistedDecision decision = (PersistedDecision)((Object)((Object)decisionOrFailure.get()));
            DecisionEvaluationResult evaluationResult = this.decisionBehavior.evaluateDecisionInDrg((ParsedDecisionRequirementsGraph)drg, decisionId, variables);
            Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> eventTuple = this.decisionBehavior.createDecisionEvaluationEvent(decision, evaluationResult);
            this.writeDecisionEvaluationEvent(eventTuple, context);
            if (evaluationResult.isFailure()) {
                return Either.left((Object)new Failure(evaluationResult.getFailureMessage(), ErrorType.DECISION_EVALUATION_ERROR, scopeKey));
            }
            return Either.right((Object)evaluationResult);
        });
        resultOrFailure.ifRight(result -> this.triggerProcessEventWithResultVariable(context, element.getResultVariable(), (DecisionEvaluationResult)result));
        return resultOrFailure;
    }

    private Either<Failure, String> evalDecisionIdExpression(ExecutableCalledDecision element, long scopeKey) {
        return this.expressionBehavior.evaluateStringExpression(element.getDecisionId(), scopeKey);
    }

    private void writeDecisionEvaluationEvent(Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> decisionEvaluationEventTuple, BpmnElementContext context) {
        DecisionEvaluationRecord evaluationEvent = (DecisionEvaluationRecord)decisionEvaluationEventTuple.getRight();
        evaluationEvent.setProcessDefinitionKey(context.getProcessDefinitionKey()).setBpmnProcessId(context.getBpmnProcessId()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementInstanceKey(context.getElementInstanceKey()).setElementId(context.getElementId());
        long newDecisionEvaluationKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(newDecisionEvaluationKey, (Intent)decisionEvaluationEventTuple.getLeft(), (RecordValue)decisionEvaluationEventTuple.getRight());
    }

    private void triggerProcessEventWithResultVariable(BpmnElementContext context, String resultVariableName, DecisionEvaluationResult result) {
        DirectBuffer resultVariable = BpmnDecisionBehavior.serializeToNamedVariable(resultVariableName, result.getOutput());
        this.eventTriggerBehavior.triggeringProcessEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getElementInstanceKey(), context.getElementId(), resultVariable);
    }

    private static DirectBuffer serializeToNamedVariable(String name, DirectBuffer value) {
        ExpandableArrayBuffer resultBuffer = new ExpandableArrayBuffer();
        MsgPackWriter writer = new MsgPackWriter();
        writer.wrap((MutableDirectBuffer)resultBuffer, 0);
        writer.writeMapHeader(1);
        writer.writeString(BufferUtil.wrapString((String)name));
        writer.writeRaw(value);
        return resultBuffer;
    }
}

