/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.List;
import java.util.stream.IntStream;

public final class CommandDistributionBehavior {
    private final StateWriter stateWriter;
    private final SideEffectWriter sideEffectWriter;
    private final List<Integer> otherPartitions;
    private final InterPartitionCommandSender interPartitionCommandSender;
    private final KeyGenerator keyGenerator;

    public CommandDistributionBehavior(Writers writers, int currentPartition, int partitionsCount, InterPartitionCommandSender partitionCommandSender, KeyGenerator keyGenerator) {
        this.stateWriter = writers.state();
        this.sideEffectWriter = writers.sideEffect();
        this.interPartitionCommandSender = partitionCommandSender;
        this.keyGenerator = keyGenerator;
        this.otherPartitions = IntStream.range(1, 1 + partitionsCount).filter(partition -> partition != currentPartition).boxed().toList();
    }

    public <T extends UnifiedRecordValue> void distributeCommand(TypedRecord<T> command) {
        CommandDistributionRecord distributionRecord = new CommandDistributionRecord().setValueType(command.getValueType()).setRecordValue(command.getValue());
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)CommandDistributionIntent.STARTED, (RecordValue)distributionRecord);
        long key = this.keyGenerator.nextKey();
        this.otherPartitions.forEach(partition -> this.distributeToPartition(command, (int)partition, distributionRecord, key));
    }

    private <T extends UnifiedRecordValue> void distributeToPartition(TypedRecord<T> command, int partition, CommandDistributionRecord distributionRecord, long key) {
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)CommandDistributionIntent.DISTRIBUTING, (RecordValue)new CommandDistributionRecord().setPartitionId(partition).setValueType(distributionRecord.getValueType()));
        this.sideEffectWriter.appendSideEffect(() -> {
            this.interPartitionCommandSender.sendCommand(partition, command.getValueType(), command.getIntent(), Long.valueOf(key), command.getValue());
            return true;
        });
    }
}

