/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public class JobRecurProcessor
implements TypedRecordProcessor<JobRecord> {
    private static final String NOT_FAILED_JOB_MESSAGE = "Expected to back off failed job with key '%d', but %s";
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public JobRecurProcessor(ProcessingState processingState, Writers writers) {
        this.jobState = processingState.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.FAILED) {
            JobRecord recurredJob = (JobRecord)record.getValue();
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.RECURRED_AFTER_BACKOFF, (RecordValue)recurredJob);
        } else {
            String errorMessage = String.format(NOT_FAILED_JOB_MESSAGE, jobKey, switch (state) {
                case JobState.State.ACTIVATABLE -> "it is already activable";
                case JobState.State.ACTIVATED -> "it is already activated";
                case JobState.State.ERROR_THROWN -> "it is in error state";
                default -> "no such job was found";
            });
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, errorMessage);
        }
    }
}

