/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class JobTimeOutProcessor
implements TypedRecordProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final JobMetrics jobMetrics;

    public JobTimeOutProcessor(ProcessingState state, Writers writers, JobMetrics jobMetrics) {
        this.jobState = state.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.jobMetrics = jobMetrics;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATED) {
            JobRecord timedOutJob = (JobRecord)record.getValue();
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.TIMED_OUT, (RecordValue)timedOutJob);
            this.jobMetrics.jobTimedOut(timedOutJob.getType());
        } else {
            String errorMessage = String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, switch (state) {
                case JobState.State.ACTIVATABLE -> "it must be activated first";
                case JobState.State.FAILED -> "it is marked as failed";
                default -> "no such job was found";
            });
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, errorMessage);
        }
    }
}

