/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.ScheduledTaskDbState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import java.util.function.Supplier;

public class TypedRecordProcessorContextImpl
implements TypedRecordProcessorContext {
    private final int partitionId;
    private final ProcessingScheduleService scheduleService;
    private final ProcessingDbState processingState;
    private final ZeebeDb zeebeDb;
    private final Writers writers;
    private final InterPartitionCommandSender partitionCommandSender;
    private final EngineConfiguration config;

    public TypedRecordProcessorContextImpl(int partitionId, ProcessingScheduleService scheduleService, ProcessingDbState processingState, ZeebeDb zeebeDb, Writers writers, InterPartitionCommandSender partitionCommandSender, EngineConfiguration config) {
        this.partitionId = partitionId;
        this.scheduleService = scheduleService;
        this.processingState = processingState;
        this.zeebeDb = zeebeDb;
        this.writers = writers;
        this.partitionCommandSender = partitionCommandSender;
        this.config = config;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public MutableProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    public Writers getWriters() {
        return this.writers;
    }

    @Override
    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    @Override
    public Supplier<ScheduledTaskState> getScheduledTaskStateFactory() {
        return () -> new ScheduledTaskDbState((ZeebeDb<ZbColumnFamilies>)this.zeebeDb, this.zeebeDb.createContext());
    }

    @Override
    public EngineConfiguration getConfig() {
        return this.config;
    }
}

