/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.processing;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.metrics.BannedInstanceMetrics;
import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class DbBannedInstanceState
implements MutableBannedInstanceState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final String BAN_INSTANCE_MESSAGE = "Ban process instance {}, due to previous errors.";
    private final ColumnFamily<DbLong, DbNil> bannedInstanceColumnFamily;
    private final DbLong processInstanceKey = new DbLong();
    private final BannedInstanceMetrics bannedInstanceMetrics;
    private boolean empty = true;

    public DbBannedInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.bannedInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.BANNED_INSTANCE, transactionContext, (DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
        this.bannedInstanceMetrics = new BannedInstanceMetrics(partitionId);
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        AtomicInteger counter = new AtomicInteger(0);
        this.bannedInstanceColumnFamily.forEach(ignore -> counter.getAndIncrement());
        this.empty = counter.get() == 0;
        this.bannedInstanceMetrics.setBannedInstanceCounter(counter.get());
    }

    private void banInstance(long key) {
        if (key >= 0L) {
            LOG.warn(BAN_INSTANCE_MESSAGE, (Object)key);
            this.empty = false;
            this.processInstanceKey.wrapLong(key);
            this.bannedInstanceColumnFamily.insert((DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
            this.bannedInstanceMetrics.countBannedInstance();
        }
    }

    private boolean isBanned(long key) {
        if (this.empty) {
            return false;
        }
        this.processInstanceKey.wrapLong(key);
        return this.bannedInstanceColumnFamily.exists((DbKey)this.processInstanceKey);
    }

    @Override
    public boolean isBanned(TypedRecord record) {
        long processInstanceKey;
        UnifiedRecordValue value = record.getValue();
        if (value instanceof ProcessInstanceRelated && (processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey()) >= 0L) {
            return this.isBanned(processInstanceKey);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean tryToBanInstance(TypedRecord<?> typedRecord, Consumer<Long> onBanningInstance) {
        UnifiedRecordValue value;
        Intent intent = typedRecord.getIntent();
        if (DbBannedInstanceState.shouldBeBanned(intent) && (value = typedRecord.getValue()) instanceof ProcessInstanceRelated) {
            long processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey();
            this.banInstance(processInstanceKey);
            onBanningInstance.accept(processInstanceKey);
        }
        return false;
    }

    @Override
    public void banProcessInstance(long processInstanceKey) {
        this.banInstance(processInstanceKey);
    }

    public static boolean shouldBeBanned(Intent intent) {
        if (intent instanceof ProcessInstanceRelatedIntent) {
            ProcessInstanceRelatedIntent processInstanceRelatedIntent = (ProcessInstanceRelatedIntent)intent;
            return processInstanceRelatedIntent.shouldBanInstanceOnError();
        }
        return false;
    }
}

