/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Licensed under the Zeebe Community License 1.1. You may not use this file
 * except in compliance with the Zeebe Community License 1.1.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess.PersistedProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;

public class ProcessDeletingApplier implements TypedEventApplier<ProcessIntent, ProcessRecord> {

  private final MutableProcessState processState;

  public ProcessDeletingApplier(final MutableProcessingState state) {
    processState = state.getProcessState();
  }

  @Override
  public void applyState(final long key, final ProcessRecord value) {
    processState.updateProcessState(
        value.getProcessDefinitionKey(), PersistedProcessState.PENDING_DELETION);
  }
}
