/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class ProcessInstanceStateTransitionGuard {
    private final BpmnStateBehavior stateBehavior;

    public ProcessInstanceStateTransitionGuard(BpmnStateBehavior stateBehavior) {
        this.stateBehavior = stateBehavior;
    }

    public Either<Failure, ?> isValidStateTransition(BpmnElementContext context, ExecutableFlowElement element) {
        return this.checkStateTransition(context, element).mapLeft(Failure::new);
    }

    private Either<String, ?> checkStateTransition(BpmnElementContext context, ExecutableFlowElement element) {
        return switch (context.getIntent()) {
            case ProcessInstanceIntent.ACTIVATE_ELEMENT -> this.hasActiveFlowScopeInstance(context).flatMap(ok -> this.canActivateParallelGateway(context, element)).flatMap(ok -> this.canActivateInclusiveGateway(context, element));
            case ProcessInstanceIntent.COMPLETE_ELEMENT -> this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING).flatMap(ok -> this.hasActiveFlowScopeInstance(context));
            case ProcessInstanceIntent.TERMINATE_ELEMENT -> this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING);
            default -> Either.left((Object)String.format("Expected the check of the preconditions of a command with intent [activate,complete,terminate] but the intent was '%s'", context.getIntent()));
        };
    }

    private Either<String, ElementInstance> getElementInstance(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (elementInstance != null) {
            return Either.right((Object)((Object)elementInstance));
        }
        return Either.left((Object)String.format("Expected element instance with key '%d' to be present in state but not found.", context.getElementInstanceKey()));
    }

    private Either<String, ElementInstance> getFlowScopeInstance(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        if (flowScopeInstance != null) {
            return Either.right((Object)((Object)flowScopeInstance));
        }
        return Either.left((Object)String.format("Expected flow scope instance with key '%d' to be present in state but not found.", context.getFlowScopeKey()));
    }

    private Either<String, ElementInstance> hasElementInstanceInState(ElementInstance elementInstance, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        ProcessInstanceIntent currentState = elementInstance.getState();
        if (expectedState != currentState && !Arrays.asList(otherExpected).contains(currentState)) {
            return Either.left((Object)String.format("Expected element instance to be in state '%s' or one of '%s' but was '%s'.", expectedState, Arrays.toString(otherExpected), currentState));
        }
        return Either.right((Object)((Object)elementInstance));
    }

    private Either<String, ?> hasElementInstanceWithState(BpmnElementContext context, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        return this.getElementInstance(context).flatMap(elementInstance -> this.hasElementInstanceInState((ElementInstance)((Object)elementInstance), expectedState, otherExpected));
    }

    private Either<String, ElementInstance> hasFlowScopeInstanceInState(ElementInstance flowScopeInstance, ProcessInstanceIntent expectedState) {
        ProcessInstanceIntent currentState = flowScopeInstance.getState();
        if (currentState != expectedState) {
            return Either.left((Object)String.format("Expected flow scope instance to be in state '%s' but was '%s'.", expectedState, currentState));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ElementInstance> hasNonInterruptedFlowScope(ElementInstance flowScopeInstance, BpmnElementContext context) {
        DirectBuffer interruptingElementId = flowScopeInstance.getInterruptingElementId();
        if (flowScopeInstance.isInterrupted() && !interruptingElementId.equals(context.getElementId())) {
            return Either.left((Object)String.format("Expected flow scope instance to be not interrupted but was interrupted by an event with id '%s'.", BufferUtil.bufferAsString((DirectBuffer)interruptingElementId)));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ?> hasActiveFlowScopeInstance(BpmnElementContext context) {
        if (context.getBpmnElementType() == BpmnElementType.PROCESS) {
            return Either.right(null);
        }
        return this.getFlowScopeInstance(context).flatMap(flowScopeInstance -> this.hasFlowScopeInstanceInState((ElementInstance)((Object)flowScopeInstance), ProcessInstanceIntent.ELEMENT_ACTIVATED)).flatMap(flowScopeInstance -> this.hasNonInterruptedFlowScope((ElementInstance)((Object)flowScopeInstance), context));
    }

    private Either<String, ?> canActivateParallelGateway(BpmnElementContext context, ExecutableFlowElement executableFlowElement) {
        if (context.getBpmnElementType() != BpmnElementType.PARALLEL_GATEWAY) {
            return Either.right(null);
        }
        ExecutableFlowNode element = (ExecutableFlowNode)executableFlowElement;
        int numberOfIncomingSequenceFlows = element.getIncoming().size();
        int numberOfTakenSequenceFlows = this.stateBehavior.getNumberOfTakenSequenceFlows(context.getFlowScopeKey(), element.getId());
        return numberOfTakenSequenceFlows >= numberOfIncomingSequenceFlows ? Either.right(null) : Either.left((Object)String.format("Expected to be able to activate parallel gateway '%s', but not all sequence flows have been taken.", BufferUtil.bufferAsString((DirectBuffer)element.getId())));
    }

    private Either<String, ?> canActivateInclusiveGateway(BpmnElementContext context, ExecutableFlowElement executableFlowElement) {
        if (context.getBpmnElementType() == BpmnElementType.INCLUSIVE_GATEWAY) {
            boolean exist;
            ExecutableFlowNode element = (ExecutableFlowNode)executableFlowElement;
            int numberOfIncomingSequenceFlows = element.getIncoming().size();
            int numberOfTakenSequenceFlows = this.stateBehavior.getNumberOfTakenSequenceFlows(context.getFlowScopeKey(), element.getId());
            if (numberOfTakenSequenceFlows < numberOfIncomingSequenceFlows && ((exist = this.doesPathExist(context, element)) || numberOfTakenSequenceFlows == 0)) {
                return Either.left((Object)String.format("Expected to be able to activate inclusive gateway '%s', but not all satisfied sequence flows have been taken.", BufferUtil.bufferAsString((DirectBuffer)element.getId())));
            }
        }
        return Either.right(null);
    }

    private boolean doesPathExist(BpmnElementContext context, ExecutableFlowElement executableFlowElement) {
        Optional<DeployedProcess> deployedProcess = this.stateBehavior.getProcess(context.getProcessDefinitionKey());
        return deployedProcess.map(executableProcess -> {
            HashSet visited = new HashSet();
            ExecutableProcess process = executableProcess.getProcess();
            DirectBuffer targetElementId = executableFlowElement.getId();
            Set<DirectBuffer> activateElementIds = this.findActivateElementInFlowScope(context, executableFlowElement);
            return activateElementIds.stream().anyMatch(elementId -> this.doesPathExist(process, (DirectBuffer)elementId, targetElementId, visited));
        }).orElse(false);
    }

    public Set<DirectBuffer> findActivateElementInFlowScope(BpmnElementContext context, ExecutableFlowElement executableFlowElement) {
        BpmnElementContext flowScopeContext = this.stateBehavior.getFlowScopeContext(context);
        List<BpmnElementContext> childInstances = this.stateBehavior.getChildInstances(flowScopeContext);
        return childInstances.stream().map(BpmnElementContext::getElementId).filter(elementId -> elementId != executableFlowElement.getId()).collect(Collectors.toSet());
    }

    public boolean doesPathExist(ExecutableProcess process, DirectBuffer sourceElementId, DirectBuffer targetElementId, Set<DirectBuffer> visited) {
        if (sourceElementId == targetElementId) {
            return true;
        }
        if (!visited.contains(sourceElementId)) {
            visited.add(sourceElementId);
            ExecutableFlowNode sourceElement = process.getElementById(sourceElementId, ExecutableFlowNode.class);
            List sourceElementIds = sourceElement.getOutgoing().stream().map(ExecutableSequenceFlow::getTarget).map(AbstractFlowElement::getId).collect(Collectors.toList());
            if (sourceElement instanceof ExecutableActivity) {
                List<ExecutableBoundaryEvent> boundaryEvents = ((ExecutableActivity)sourceElement).getBoundaryEvents();
                boundaryEvents.forEach(event -> sourceElementIds.add(event.getId()));
            }
            return sourceElementIds.stream().anyMatch(elementId -> this.doesPathExist(process, (DirectBuffer)elementId, targetElementId, visited));
        }
        return false;
    }
}

