/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.job.JobVariablesCollector;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJobImpl;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BpmnJobActivationBehavior {
    private final JobStreamer jobStreamer;
    private final JobVariablesCollector jobVariablesCollector;
    private final StateWriter stateWriter;
    private final SideEffectWriter sideEffectWriter;
    private final KeyGenerator keyGenerator;
    private final JobMetrics jobMetrics;

    public BpmnJobActivationBehavior(JobStreamer jobStreamer, VariableState variableState, Writers writers, KeyGenerator keyGenerator, JobMetrics jobMetrics) {
        this.jobStreamer = jobStreamer;
        this.keyGenerator = keyGenerator;
        this.jobMetrics = jobMetrics;
        this.jobVariablesCollector = new JobVariablesCollector(variableState);
        this.stateWriter = writers.state();
        this.sideEffectWriter = writers.sideEffect();
    }

    public void publishWork(long jobKey, JobRecord jobRecord) {
        JobRecord wrappedJobRecord = new JobRecord();
        wrappedJobRecord.wrapWithoutVariables(jobRecord);
        String jobType = wrappedJobRecord.getType();
        Optional<JobStreamer.JobStream> optionalJobStream = this.jobStreamer.streamFor(wrappedJobRecord.getTypeBuffer());
        if (optionalJobStream.isPresent()) {
            JobStreamer.JobStream jobStream = optionalJobStream.get();
            JobActivationProperties properties = jobStream.properties();
            this.setJobProperties(wrappedJobRecord, properties);
            JobBatchRecord jobBatchRecord = this.createJobBatchRecord(wrappedJobRecord, properties);
            this.appendJobToBatch(jobBatchRecord, jobKey, wrappedJobRecord);
            long jobBatchKey = this.keyGenerator.nextKey();
            this.stateWriter.appendFollowUpEvent(jobBatchKey, (Intent)JobBatchIntent.ACTIVATED, (RecordValue)jobBatchRecord);
            this.jobVariablesCollector.setJobVariables(properties.fetchVariables(), wrappedJobRecord);
            JobRecord pushableJobRecord = new JobRecord();
            this.cloneJob(wrappedJobRecord, pushableJobRecord);
            ActivatedJobImpl activatedJob = new ActivatedJobImpl();
            activatedJob.setJobKey(jobKey).setRecord(pushableJobRecord);
            this.sideEffectWriter.appendSideEffect(() -> {
                jobStream.push((ActivatedJob)activatedJob);
                this.jobMetrics.jobPush(jobType);
                return true;
            });
        } else {
            this.notifyJobAvailable(jobType);
        }
    }

    public void notifyJobAvailableAsSideEffect(JobRecord jobRecord) {
        String jobType = jobRecord.getType();
        this.notifyJobAvailable(jobType);
    }

    private void notifyJobAvailable(String jobType) {
        this.sideEffectWriter.appendSideEffect(() -> {
            this.jobStreamer.notifyWorkAvailable(jobType);
            this.jobMetrics.jobNotification(jobType);
            return true;
        });
    }

    private void setJobProperties(JobRecord jobRecord, JobActivationProperties properties) {
        long deadline = ActorClock.currentTimeMillis() + properties.timeout();
        jobRecord.setDeadline(deadline);
        jobRecord.setWorker(properties.worker());
    }

    private JobBatchRecord createJobBatchRecord(JobRecord jobRecord, JobActivationProperties properties) {
        JobBatchRecord jobBatchRecord = new JobBatchRecord();
        jobBatchRecord.setType(jobRecord.getType()).setTimeout(properties.timeout()).setWorker(properties.worker());
        return jobBatchRecord;
    }

    private void appendJobToBatch(JobBatchRecord jobBatchRecord, Long jobKey, JobRecord jobRecord) {
        ((LongValue)jobBatchRecord.jobKeys().add()).setValue(jobKey.longValue());
        ((JobRecord)jobBatchRecord.jobs().add()).wrapWithoutVariables(jobRecord);
    }

    private void cloneJob(JobRecord jobRecord, JobRecord jobRecordClone) {
        byte[] bytes = new byte[jobRecord.getLength()];
        UnsafeBuffer jobCopyBuffer = new UnsafeBuffer(bytes);
        jobRecord.write((MutableDirectBuffer)jobCopyBuffer, 0);
        jobRecordClone.wrap((DirectBuffer)jobCopyBuffer, 0, jobRecord.getLength());
    }
}

