/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ParallelGatewayProcessor
implements BpmnElementProcessor<ExecutableFlowNode> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior bpmnIncidentBehavior;

    public ParallelGatewayProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.bpmnIncidentBehavior = behaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableFlowNode> getType() {
        return ExecutableFlowNode.class;
    }

    @Override
    public void onActivate(ExecutableFlowNode element, BpmnElementContext context) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
        BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
        this.stateTransitionBehavior.transitionToCompleted(element, completing).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.bpmnIncidentBehavior.createIncident((Failure)failure, completing));
    }

    @Override
    public void onComplete(ExecutableFlowNode element, BpmnElementContext context) {
        throw new UnsupportedOperationException(String.format("Expected to explicitly process complete, but gateway %s has already been completed on processing activate", BufferUtil.bufferAsString((DirectBuffer)context.getElementId())));
    }

    @Override
    public void onTerminate(ExecutableFlowNode element, BpmnElementContext context) {
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

