/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.element;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.agrona.DirectBuffer;

public class ExecutableActivity
extends ExecutableFlowNode
implements ExecutableCatchEventSupplier {
    private final List<ExecutableBoundaryEvent> boundaryEvents = new ArrayList<ExecutableBoundaryEvent>();
    private final List<ExecutableFlowElementContainer> eventSubprocesses = new ArrayList<ExecutableFlowElementContainer>();
    private final List<ExecutableCatchEvent> catchEvents = new ArrayList<ExecutableCatchEvent>();
    private final List<DirectBuffer> interruptingIds = new ArrayList<DirectBuffer>();
    private final List<DirectBuffer> boundaryElementIds = new ArrayList<DirectBuffer>();

    public ExecutableActivity(String id) {
        super(id);
    }

    public void attach(ExecutableBoundaryEvent boundaryEvent) {
        this.boundaryEvents.add(boundaryEvent);
        this.catchEvents.add(boundaryEvent);
        DirectBuffer boundaryEventElementId = boundaryEvent.getId();
        this.boundaryElementIds.add(boundaryEventElementId);
        if (boundaryEvent.interrupting()) {
            this.interruptingIds.add(boundaryEventElementId);
        }
    }

    public void attach(ExecutableFlowElementContainer eventSubprocess) {
        this.eventSubprocesses.add(eventSubprocess);
        ExecutableStartEvent startEvent = eventSubprocess.getStartEvents().get(0);
        this.catchEvents.add(0, startEvent);
        if (startEvent.interrupting()) {
            this.interruptingIds.add(startEvent.getId());
        }
    }

    @Override
    public List<ExecutableCatchEvent> getEvents() {
        return this.catchEvents;
    }

    @Override
    public Collection<DirectBuffer> getInterruptingElementIds() {
        return this.interruptingIds;
    }

    @Override
    public Collection<DirectBuffer> getBoundaryElementIds() {
        return this.boundaryElementIds;
    }

    public List<ExecutableBoundaryEvent> getBoundaryEvents() {
        return this.boundaryEvents;
    }

    public List<ExecutableFlowElementContainer> getEventSubprocesses() {
        return this.eventSubprocesses;
    }
}

