/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.ExpressionTransformer;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAssignmentDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskSchedule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class UserTaskTransformer
implements ModelElementTransformer<UserTask> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final ExpressionLanguage expressionLanguage;

    public UserTaskTransformer(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public Class<UserTask> getType() {
        return UserTask.class;
    }

    @Override
    public void transform(UserTask element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableJobWorkerTask userTask = process.getElementById(element.getId(), ExecutableJobWorkerTask.class);
        JobWorkerProperties jobWorkerProperties = new JobWorkerProperties();
        userTask.setJobWorkerProperties(jobWorkerProperties);
        this.transformTaskDefinition(jobWorkerProperties);
        this.transformAssignmentDefinition(element, jobWorkerProperties);
        this.transformTaskSchedule(element, jobWorkerProperties);
        this.transformTaskHeaders(element, jobWorkerProperties);
    }

    private void transformTaskDefinition(JobWorkerProperties jobWorkerProperties) {
        jobWorkerProperties.setType((Expression)new StaticExpression("io.camunda.zeebe:userTask"));
        jobWorkerProperties.setRetries((Expression)new StaticExpression("1"));
    }

    private void transformAssignmentDefinition(UserTask element, JobWorkerProperties jobWorkerProperties) {
        String candidateUsers;
        String candidateGroups;
        ZeebeAssignmentDefinition assignmentDefinition = (ZeebeAssignmentDefinition)element.getSingleExtensionElement(ZeebeAssignmentDefinition.class);
        if (assignmentDefinition == null) {
            return;
        }
        String assignee = assignmentDefinition.getAssignee();
        if (assignee != null && !assignee.isBlank()) {
            jobWorkerProperties.setAssignee(this.expressionLanguage.parseExpression(assignee));
        }
        if ((candidateGroups = assignmentDefinition.getCandidateGroups()) != null && !candidateGroups.isBlank()) {
            Expression candidateGroupsExpression = this.expressionLanguage.parseExpression(candidateGroups);
            if (candidateGroupsExpression.isStatic()) {
                jobWorkerProperties.setCandidateGroups((Expression)ExpressionTransformer.parseListOfCsv(candidateGroups).map(ExpressionTransformer::asListLiteral).map(ExpressionTransformer::asFeelExpressionString).map(arg_0 -> ((ExpressionLanguage)this.expressionLanguage).parseExpression(arg_0)).get());
            } else {
                jobWorkerProperties.setCandidateGroups(candidateGroupsExpression);
            }
        }
        if ((candidateUsers = assignmentDefinition.getCandidateUsers()) != null && !candidateUsers.isBlank()) {
            Expression candidateUsersExpression = this.expressionLanguage.parseExpression(candidateUsers);
            if (candidateUsersExpression.isStatic()) {
                jobWorkerProperties.setCandidateUsers((Expression)ExpressionTransformer.parseListOfCsv(candidateUsers).map(ExpressionTransformer::asListLiteral).map(ExpressionTransformer::asFeelExpressionString).map(arg_0 -> ((ExpressionLanguage)this.expressionLanguage).parseExpression(arg_0)).get());
            } else {
                jobWorkerProperties.setCandidateUsers(candidateUsersExpression);
            }
        }
    }

    private void transformTaskSchedule(UserTask element, JobWorkerProperties jobWorkerProperties) {
        String followUpDate;
        ZeebeTaskSchedule taskSchedule = (ZeebeTaskSchedule)element.getSingleExtensionElement(ZeebeTaskSchedule.class);
        if (taskSchedule == null) {
            return;
        }
        String dueDate = taskSchedule.getDueDate();
        if (dueDate != null && !dueDate.isBlank()) {
            jobWorkerProperties.setDueDate(this.expressionLanguage.parseExpression(dueDate));
        }
        if ((followUpDate = taskSchedule.getFollowUpDate()) != null && !followUpDate.isBlank()) {
            jobWorkerProperties.setFollowUpDate(this.expressionLanguage.parseExpression(followUpDate));
        }
    }

    private void transformTaskHeaders(UserTask element, JobWorkerProperties jobWorkerProperties) {
        HashMap<String, String> taskHeaders = new HashMap<String, String>();
        this.collectModelTaskHeaders(element, taskHeaders);
        this.addZeebeUserTaskFormKeyHeader(element, taskHeaders);
        if (!taskHeaders.isEmpty()) {
            jobWorkerProperties.setTaskHeaders(taskHeaders);
        }
    }

    private void addZeebeUserTaskFormKeyHeader(UserTask element, Map<String, String> taskHeaders) {
        ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
        if (formDefinition != null) {
            taskHeaders.put("io.camunda.zeebe:formKey", formDefinition.getFormKey());
        }
    }

    private void collectModelTaskHeaders(UserTask element, Map<String, String> taskHeaders) {
        ZeebeTaskHeaders modelTaskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (modelTaskHeaders != null) {
            List<ZeebeHeader> validHeaders = modelTaskHeaders.getHeaders().stream().filter(this::isValidHeader).collect(Collectors.toList());
            if (validHeaders.size() < modelTaskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            validHeaders.forEach(h -> taskHeaders.put(h.getKey(), h.getValue()));
        }
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && this.isValidHeader(header.getKey(), header.getValue());
    }

    private boolean isValidHeader(String key, String value) {
        return key != null && !key.isEmpty() && value != null && !value.isEmpty();
    }
}

