/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class StraightThroughProcessingLoopValidator {
    private static final EnumSet<BpmnElementType> STRAIGHT_THROUGH_PROCESSING_ELEMENT_TYPES = EnumSet.of(BpmnElementType.MANUAL_TASK, new BpmnElementType[]{BpmnElementType.TASK, BpmnElementType.EXCLUSIVE_GATEWAY, BpmnElementType.INCLUSIVE_GATEWAY, BpmnElementType.PARALLEL_GATEWAY, BpmnElementType.START_EVENT, BpmnElementType.END_EVENT, BpmnElementType.SUB_PROCESS, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.CALL_ACTIVITY});
    private static final EnumSet<BpmnElementType> REJECTED_ELEMENT_TYPES = EnumSet.of(BpmnElementType.MANUAL_TASK, BpmnElementType.TASK, BpmnElementType.CALL_ACTIVITY);

    public static Either<Failure, ?> validate(DeploymentResource resource, List<ExecutableProcess> executableProcesses) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (ExecutableProcess executableProcess : executableProcesses) {
            try {
                StraightThroughProcessingLoopValidator.hasStraightThroughProcessingLoop(resource, executableProcess, executableProcesses).ifLeft(failures::add);
            }
            catch (StackOverflowError e) {
                String message = String.format("Process contains a very long chain of tasks of type %s", REJECTED_ELEMENT_TYPES);
                failures.add(new Failure(StraightThroughProcessingLoopValidator.createFormattedFailureMessage(resource, executableProcess, message)));
            }
        }
        if (failures.isEmpty()) {
            return Either.right(null);
        }
        StringWriter writer = new StringWriter();
        failures.forEach(failure -> writer.write(failure.getMessage()));
        return Either.left((Object)new Failure(writer.toString()));
    }

    private static Either<Failure, ?> hasStraightThroughProcessingLoop(DeploymentResource resource, ExecutableProcess executableProcess, List<ExecutableProcess> executableProcesses) {
        List<ExecutableFlowNode> straightThroughElements = StraightThroughProcessingLoopValidator.getStraightThroughElementsInProcess(executableProcess);
        Iterator<ExecutableFlowNode> iterator = straightThroughElements.iterator();
        while (iterator.hasNext()) {
            LinkedList<ExecutableFlowNode> potentialLoop = new LinkedList<ExecutableFlowNode>();
            ExecutableFlowNode element = iterator.next();
            Either<List<ExecutableFlowNode>, ?> result = StraightThroughProcessingLoopValidator.checkForStraightThroughProcessingLoop(potentialLoop, element, executableProcesses);
            if (!result.isLeft()) continue;
            String failureMessage = StraightThroughProcessingLoopValidator.createFailureMessage(resource, executableProcess, (List)result.getLeft());
            return Either.left((Object)new Failure(failureMessage));
        }
        return Either.right(null);
    }

    private static List<ExecutableFlowNode> getStraightThroughElementsInProcess(ExecutableProcess executableProcess) {
        return executableProcess.getFlowElements().stream().map(flowElement -> flowElement instanceof ExecutableMultiInstanceBody ? ((ExecutableMultiInstanceBody)flowElement).getInnerActivity() : flowElement).filter(flowElement -> REJECTED_ELEMENT_TYPES.contains(flowElement.getElementType())).map(ExecutableFlowNode.class::cast).sorted(Comparator.comparing(AbstractFlowElement::getId)).toList();
    }

    private static Either<List<ExecutableFlowNode>, ?> checkForStraightThroughProcessingLoop(LinkedList<ExecutableFlowNode> potentialLoop, ExecutableFlowNode element, List<ExecutableProcess> executableProcesses) {
        if (StraightThroughProcessingLoopValidator.foundLoop(potentialLoop, element)) {
            List<ExecutableFlowNode> loop = potentialLoop.subList(potentialLoop.indexOf(element), potentialLoop.size());
            loop.add(element);
            return Either.left(loop);
        }
        if (STRAIGHT_THROUGH_PROCESSING_ELEMENT_TYPES.contains(element.getElementType())) {
            ExecutableFlowNode nextElement;
            if (element.getElementType() != BpmnElementType.MULTI_INSTANCE_BODY) {
                potentialLoop.addLast(element);
            }
            Either<List<ExecutableFlowNode>, ?> isPartOfLoop = Either.right(null);
            Iterator<? extends ExecutableFlowNode> iterator = StraightThroughProcessingLoopValidator.getNextElements(element, executableProcesses).iterator();
            while (iterator.hasNext() && !(isPartOfLoop = StraightThroughProcessingLoopValidator.checkForStraightThroughProcessingLoop(potentialLoop, nextElement = iterator.next(), executableProcesses)).isLeft()) {
            }
            if (isPartOfLoop.isRight()) {
                potentialLoop.remove(element);
            }
            return isPartOfLoop;
        }
        return Either.right(null);
    }

    private static List<? extends ExecutableFlowNode> getNextElements(ExecutableFlowNode element, List<ExecutableProcess> executableProcesses) {
        switch (element.getElementType()) {
            case SUB_PROCESS: {
                ExecutableFlowElementContainer subProcess = (ExecutableFlowElementContainer)element;
                return List.of(subProcess.getNoneStartEvent());
            }
            case CALL_ACTIVITY: {
                ExecutableCallActivity callActivity = (ExecutableCallActivity)element;
                Expression expression = callActivity.getCalledElementProcessId();
                if (expression.isStatic()) {
                    String calledActivityId = ((StaticExpression)expression).getString();
                    Optional<ExecutableProcess> calledProcess = executableProcesses.stream().filter(process -> BufferUtil.bufferAsString((DirectBuffer)process.getId()).equals(calledActivityId)).findFirst();
                    return calledProcess.map(process -> List.of(process.getNoneStartEvent())).orElseGet(Collections::emptyList);
                }
                return Collections.emptyList();
            }
            case MULTI_INSTANCE_BODY: {
                ExecutableMultiInstanceBody multiInstance = (ExecutableMultiInstanceBody)element;
                return List.of(multiInstance.getInnerActivity());
            }
        }
        List<ExecutableSequenceFlow> outgoingFlows = element.getOutgoing();
        if (!outgoingFlows.isEmpty()) {
            return outgoingFlows.stream().map(ExecutableSequenceFlow::getTarget).toList();
        }
        ExecutableFlowElement flowScope = element.getFlowScope();
        if (flowScope instanceof ExecutableFlowNode) {
            return ((ExecutableFlowNode)flowScope).getOutgoing().stream().map(ExecutableSequenceFlow::getTarget).toList();
        }
        return Collections.emptyList();
    }

    private static boolean foundLoop(LinkedList<ExecutableFlowNode> potentialLoop, ExecutableFlowNode element) {
        boolean loopContainsRejectedElements = potentialLoop.stream().map(AbstractFlowElement::getElementType).anyMatch(REJECTED_ELEMENT_TYPES::contains);
        return potentialLoop.contains(element) && loopContainsRejectedElements;
    }

    private static String createFailureMessage(DeploymentResource resource, ExecutableProcess executableProcess, List<ExecutableFlowNode> loopingElements) {
        List<String> loopingElementIds = loopingElements.stream().map(AbstractFlowElement::getId).map(BufferUtil::bufferAsString).toList();
        String failureMessage = String.format("Processes are not allowed to contain a straight-through processing loop: %s", String.join((CharSequence)" > ", loopingElementIds));
        return StraightThroughProcessingLoopValidator.createFormattedFailureMessage(resource, executableProcess, failureMessage);
    }

    private static String createFormattedFailureMessage(DeploymentResource resource, ExecutableProcess executableProcess, String message) {
        StringWriter writer = new StringWriter();
        writer.write(String.format("`%s`: - Process: %s", resource.getResourceName(), BufferUtil.bufferAsString((DirectBuffer)executableProcess.getId())));
        writer.write("\n");
        writer.write("    - ERROR: ");
        writer.write(message);
        writer.write("\n");
        return writer.toString();
    }
}

