/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;

public final class PendingMessageSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final PendingMessageSubscriptionState state;
    private final long subscriptionTimeout;

    public PendingMessageSubscriptionChecker(SubscriptionCommandSender commandSender, PendingMessageSubscriptionState state, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.state = state;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.state.visitPending(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(MessageSubscription subscription) {
        MessageSubscriptionRecord record = subscription.getRecord();
        this.commandSender.sendDirectCorrelateProcessMessageSubscription(record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessIdBuffer(), record.getMessageNameBuffer(), record.getMessageKey(), record.getVariablesBuffer(), record.getCorrelationKeyBuffer());
        long sentTime = ActorClock.currentTimeMillis();
        this.state.onSent(record, sentTime);
        return true;
    }
}

