/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class ResourceDeletionProcessor
implements DistributedTypedRecordProcessor<ResourceDeletionRecord> {
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final KeyGenerator keyGenerator;
    private final DecisionState decisionState;
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final TimerInstanceState timerInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final ExpressionProcessor expressionProcessor;
    private final StartEventSubscriptionManager startEventSubscriptionManager;

    public ResourceDeletionProcessor(Writers writers, KeyGenerator keyGenerator, ProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior, BpmnBehaviors bpmnBehaviors) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.keyGenerator = keyGenerator;
        this.decisionState = processingState.getDecisionState();
        this.commandDistributionBehavior = commandDistributionBehavior;
        this.processState = processingState.getProcessState();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.timerInstanceState = processingState.getTimerState();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(processingState, keyGenerator, this.stateWriter);
    }

    @Override
    public void processNewCommand(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        long eventKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ResourceDeletionIntent.DELETING, (RecordValue)value);
        this.tryDeleteResources(command);
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ResourceDeletionIntent.DELETED, (RecordValue)value);
        this.commandDistributionBehavior.distributeCommand(eventKey, command);
        this.responseWriter.writeEventOnCommand(eventKey, (Intent)ResourceDeletionIntent.DELETING, (UnpackedObject)value, command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)ResourceDeletionIntent.DELETING, (RecordValue)value);
        this.tryDeleteResources(command);
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)ResourceDeletionIntent.DELETED, (RecordValue)value);
        this.commandDistributionBehavior.acknowledgeCommand(command.getKey(), command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ResourceDeletionRecord> command, Throwable error) {
        if (error instanceof NoSuchResourceException) {
            NoSuchResourceException exception = (NoSuchResourceException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof ActiveProcessInstancesException) {
            ActiveProcessInstancesException exception = (ActiveProcessInstancesException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private void tryDeleteResources(TypedRecord<ResourceDeletionRecord> command) {
        ResourceDeletionRecord value = (ResourceDeletionRecord)command.getValue();
        Optional<DeployedProcess> processOptional = Optional.ofNullable(this.processState.getProcessByKey(value.getResourceKey()));
        if (processOptional.isPresent()) {
            this.deleteProcess(processOptional.get());
            return;
        }
        Optional<DeployedDrg> drgOptional = this.decisionState.findDecisionRequirementsByKey(value.getResourceKey());
        if (drgOptional.isPresent()) {
            this.deleteDecisionRequirements(drgOptional.get());
            return;
        }
        throw new NoSuchResourceException(value.getResourceKey());
    }

    private void deleteDecisionRequirements(DeployedDrg drg) {
        this.decisionState.findDecisionsByDecisionRequirementsKey(drg.getDecisionRequirementsKey()).forEach(this::deleteDecision);
        DecisionRequirementsRecord drgRecord = new DecisionRequirementsRecord().setDecisionRequirementsId(BufferUtil.bufferAsString((DirectBuffer)drg.getDecisionRequirementsId())).setDecisionRequirementsName(BufferUtil.bufferAsString((DirectBuffer)drg.getDecisionRequirementsName())).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setResourceName(BufferUtil.bufferAsString((DirectBuffer)drg.getResourceName())).setChecksum(drg.getChecksum()).setResource(drg.getResource());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)DecisionRequirementsIntent.DELETED, (RecordValue)drgRecord);
    }

    private void deleteDecision(PersistedDecision persistedDecision) {
        DecisionRecord decisionRecord = new DecisionRecord().setDecisionId(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).setDecisionName(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).setVersion(persistedDecision.getVersion()).setDecisionKey(persistedDecision.getDecisionKey()).setDecisionRequirementsId(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).setDecisionRequirementsKey(persistedDecision.getDecisionRequirementsKey());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)DecisionIntent.DELETED, (RecordValue)decisionRecord);
    }

    private void deleteProcess(DeployedProcess process) {
        boolean hasRunningInstances;
        DirectBuffer processIdBuffer = process.getBpmnProcessId();
        ProcessRecord processRecord = new ProcessRecord().setBpmnProcessId(processIdBuffer).setVersion(process.getVersion()).setKey(process.getKey()).setResourceName(process.getResourceName());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)ProcessIntent.DELETING, (RecordValue)processRecord);
        String processId = processRecord.getBpmnProcessId();
        int latestVersion = this.processState.getLatestProcessVersion(processId);
        if (latestVersion == process.getVersion()) {
            this.unsubscribeStartEvents(process);
            Optional<Integer> previousVersion = this.processState.findProcessVersionBefore(processId, latestVersion);
            if (previousVersion.isPresent()) {
                DeployedProcess previousProcess = this.processState.getProcessByProcessIdAndVersion(processIdBuffer, previousVersion.get());
                this.resubscribeStartEvents(previousProcess);
            }
        }
        if (hasRunningInstances = this.elementInstanceState.hasActiveProcessInstances(process.getKey())) {
            throw new ActiveProcessInstancesException(process.getKey());
        }
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)ProcessIntent.DELETED, (RecordValue)processRecord);
    }

    private void unsubscribeStartEvents(DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        if (process.hasTimerStartEvent()) {
            this.timerInstanceState.forEachTimerForElementInstance(-1L, timer -> {
                if (timer.getProcessDefinitionKey() == deployedProcess.getKey()) {
                    this.catchEventBehavior.unsubscribeFromTimerEvent((TimerInstance)((Object)timer));
                }
            });
        }
        this.startEventSubscriptionManager.closeStartEventSubscriptions(deployedProcess);
    }

    private void resubscribeStartEvents(DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        if (process.hasTimerStartEvent()) {
            process.getStartEvents().stream().filter(ExecutableCatchEventElement::isTimer).forEach(timerStartEvent -> {
                Either<Failure, Timer> failureOrTimer = timerStartEvent.getTimerFactory().apply(this.expressionProcessor, -1L);
                if (failureOrTimer.isLeft()) {
                    throw new ExpressionProcessor.EvaluationException(((Failure)failureOrTimer.getLeft()).getMessage());
                }
                this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, deployedProcess.getKey(), timerStartEvent.getId(), (Timer)failureOrTimer.get());
            });
        }
        this.startEventSubscriptionManager.openStartEventSubscriptions(deployedProcess);
    }

    private static final class NoSuchResourceException
    extends IllegalStateException {
        private static final String ERROR_MESSAGE_RESOURCE_NOT_FOUND = "Expected to delete resource but no resource found with key `%d`";

        private NoSuchResourceException(long resourceKey) {
            super(String.format(ERROR_MESSAGE_RESOURCE_NOT_FOUND, resourceKey));
        }
    }

    private static final class ActiveProcessInstancesException
    extends IllegalStateException {
        private static final String ERROR_MESSAGE_RUNNING_INSTANCES = "Expected to delete resource with key `%d` but there are still running instances";

        private ActiveProcessInstancesException(long processDefinitionKey) {
            super(String.format(ERROR_MESSAGE_RUNNING_INSTANCES, processDefinitionKey));
        }
    }
}

