/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class DbFormState
implements MutableFormState {
    private final DbLong dbFormKey = new DbLong();
    private final PersistedForm dbPersistedForm = new PersistedForm();
    private final ColumnFamily<DbLong, PersistedForm> formsByKey;
    private final DbString dbFormId;
    private final DbForeignKey<DbLong> fkForm;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestFormKeysByFormId;

    public DbFormState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.formsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.FORMS, transactionContext, (DbKey)this.dbFormKey, (DbValue)this.dbPersistedForm);
        this.dbFormId = new DbString();
        this.fkForm = new DbForeignKey((DbKey)this.dbFormKey, (Enum)ZbColumnFamilies.FORMS);
        this.latestFormKeysByFormId = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.LATEST_FORM_KEY_BY_FORM_ID, transactionContext, (DbKey)this.dbFormId, this.fkForm);
    }

    @Override
    public void storeFormRecord(FormRecord record) {
        this.dbFormKey.wrapLong(record.getFormKey());
        this.dbPersistedForm.wrap(record);
        this.formsByKey.upsert((DbKey)this.dbFormKey, (DbValue)this.dbPersistedForm);
        this.updateLatestFormVersion(record);
    }

    @Override
    public Optional<PersistedForm> findLatestFormById(DirectBuffer formId) {
        this.dbFormId.wrapBuffer(formId);
        return Optional.ofNullable((DbForeignKey)this.latestFormKeysByFormId.get((DbKey)this.dbFormId)).flatMap(formKey -> this.findFormByKey(((DbLong)formKey.inner()).getValue()));
    }

    @Override
    public Optional<PersistedForm> findFormByKey(long formKey) {
        this.dbFormKey.wrapLong(formKey);
        return Optional.ofNullable((PersistedForm)this.formsByKey.get((DbKey)this.dbFormKey)).map(PersistedForm::copy);
    }

    private void updateFormAsLatestVersion(FormRecord record) {
        this.dbFormId.wrapBuffer(record.getFormIdBuffer());
        this.dbFormKey.wrapLong(record.getFormKey());
        this.latestFormKeysByFormId.update((DbKey)this.dbFormId, this.fkForm);
    }

    private void updateLatestFormVersion(FormRecord record) {
        this.findLatestFormById(record.getFormIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getVersion() > previousVersion.getVersion()) {
                this.updateFormAsLatestVersion(record);
            }
        }, () -> this.insertFormAsLatestVersion(record));
    }

    private void insertFormAsLatestVersion(FormRecord record) {
        this.dbFormId.wrapBuffer(record.getFormIdBuffer());
        this.dbFormKey.wrapLong(record.getFormKey());
        this.latestFormKeysByFormId.upsert((DbKey)this.dbFormId, this.fkForm);
    }
}

