/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.ProcessVersionInfo;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public final class ProcessVersionManager {
    private final long initialValue;
    private final ColumnFamily<DbString, ProcessVersionInfo> processVersionInfoColumnFamily;
    private final DbString processIdKey;
    private final ProcessVersionInfo nextVersion = new ProcessVersionInfo();
    private final Object2ObjectHashMap<String, ProcessVersionInfo> versionCache;

    public ProcessVersionManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.initialValue = initialValue;
        this.processIdKey = new DbString();
        this.processVersionInfoColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_VERSION, transactionContext, (DbKey)this.processIdKey, (DbValue)this.nextVersion);
        this.versionCache = new Object2ObjectHashMap();
    }

    private ProcessVersionInfo getVersionInfo() {
        ProcessVersionInfo versionInfo = (ProcessVersionInfo)((Object)this.versionCache.computeIfAbsent((Object)this.processIdKey.toString(), key -> (ProcessVersionInfo)this.processVersionInfoColumnFamily.get((DbKey)this.processIdKey)));
        if (versionInfo == null) {
            return new ProcessVersionInfo().setHighestVersionIfHigher(this.initialValue);
        }
        return versionInfo;
    }

    public void addProcessVersion(String processId, long value) {
        this.processIdKey.wrapString(processId);
        ProcessVersionInfo versionInfo = this.getVersionInfo();
        versionInfo.addKnownVersion(value);
        this.processVersionInfoColumnFamily.upsert((DbKey)this.processIdKey, (DbValue)versionInfo);
        this.versionCache.put((Object)processId, (Object)versionInfo);
    }

    public void deleteProcessVersion(String processId, long version) {
        this.processIdKey.wrapString(processId);
        ProcessVersionInfo versionInfo = this.getVersionInfo();
        versionInfo.removeKnownVersion(version);
        this.processVersionInfoColumnFamily.update((DbKey)this.processIdKey, (DbValue)versionInfo);
        this.versionCache.put((Object)processId, (Object)versionInfo);
    }

    public void clear() {
        this.versionCache.clear();
    }

    public long getLatestProcessVersion(String processId) {
        this.processIdKey.wrapString(processId);
        return this.getVersionInfo().getLatestVersion();
    }

    public long getLatestProcessVersion(DirectBuffer processId) {
        this.processIdKey.wrapBuffer(processId);
        return this.getVersionInfo().getLatestVersion();
    }

    public long getHighestProcessVersion(String processId) {
        this.processIdKey.wrapString(processId);
        return this.getHighestProcessVersion();
    }

    public long getHighestProcessVersion(DirectBuffer processId) {
        this.processIdKey.wrapBuffer(processId);
        return this.getHighestProcessVersion();
    }

    private long getHighestProcessVersion() {
        return this.getVersionInfo().getHighestVersion();
    }

    public Optional<Integer> findProcessVersionBefore(String processId, long version) {
        this.processIdKey.wrapString(processId);
        return this.getVersionInfo().findVersionBefore(version);
    }
}

