/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PersistedCommandDistribution
extends UnpackedObject
implements DbValue {
    private final EnumProperty<ValueType> valueTypeProperty = new EnumProperty("valueType", ValueType.class);
    private final IntegerProperty intentProperty = new IntegerProperty("intent", 255);
    private final ObjectProperty<UnifiedRecordValue> commandValueProperty = new ObjectProperty("commandValue", (ObjectValue)new UnifiedRecordValue());

    public PersistedCommandDistribution() {
        this.declareProperty((BaseProperty)this.valueTypeProperty).declareProperty((BaseProperty)this.intentProperty).declareProperty(this.commandValueProperty);
    }

    public PersistedCommandDistribution wrap(CommandDistributionRecord commandDistributionRecord) {
        this.valueTypeProperty.setValue((Enum)commandDistributionRecord.getValueType());
        this.intentProperty.setValue((int)commandDistributionRecord.getIntent().value());
        UnifiedRecordValue commandValue = commandDistributionRecord.getCommandValue();
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = commandValue.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        commandValue.write((MutableDirectBuffer)valueBuffer, 0);
        ((UnifiedRecordValue)this.commandValueProperty.getValue()).wrap((DirectBuffer)valueBuffer, 0, encodedLength);
        return this;
    }

    public ValueType getValueType() {
        return (ValueType)this.valueTypeProperty.getValue();
    }

    public Intent getIntent() {
        int intentValue = this.intentProperty.getValue();
        if (intentValue < 0 || intentValue > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Expected to read the intent, but it's persisted value '%d' is not a short integer", intentValue));
        }
        return Intent.fromProtocolValue((ValueType)this.getValueType(), (short)((short)intentValue));
    }

    public UnifiedRecordValue getCommandValue() {
        return (UnifiedRecordValue)this.commandValueProperty.getValue();
    }
}

