/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class DbMessageSubscriptionState
implements MutableMessageSubscriptionState,
PendingMessageSubscriptionState,
StreamProcessorLifecycleAware {
    private final DbLong elementInstanceKey = new DbLong();
    private final DbString messageName = new DbString();
    private final MessageSubscription messageSubscription = new MessageSubscription();
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, MessageSubscription> subscriptionColumnFamily;
    private final DbString correlationKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong> nameCorrelationAndElementInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;
    private final TransientPendingSubscriptionState transientState;

    public DbMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, TransientPendingSubscriptionState transientState) {
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, (DbValue)this.messageSubscription);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.correlationKey);
        this.nameCorrelationAndElementInstanceKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.elementInstanceKey);
        this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, transactionContext, this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
        this.transientState = transientState;
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.subscriptionColumnFamily.forEach(subscription -> {
            if (subscription.isCorrelating()) {
                this.transientState.add(new TransientPendingSubscriptionState.PendingSubscription(this.elementInstanceKey.getValue(), this.messageName.toString()), ActorClock.currentTimeMillis());
            }
        });
    }

    @Override
    public MessageSubscription get(long elementInstanceKey, DirectBuffer messageName) {
        this.messageName.wrapBuffer(messageName);
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        return (MessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    @Override
    public void visitSubscriptions(DirectBuffer messageName, DirectBuffer correlationKey, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        this.messageName.wrapBuffer(messageName);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageNameAndCorrelationKeyColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> this.visitMessageSubscription(this.elementKeyAndMessageName, visitor));
    }

    @Override
    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    @Override
    public void put(long key, MessageSubscriptionRecord record) {
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.messageSubscription.setKey(key).setRecord(record).setCorrelating(false);
        this.subscriptionColumnFamily.insert(this.elementKeyAndMessageName, (DbValue)this.messageSubscription);
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.insert(this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void updateToCorrelatingState(MessageSubscriptionRecord record) {
        MessageSubscription subscription;
        long messageKey = record.getMessageKey();
        DirectBuffer messageVariables = record.getVariablesBuffer();
        if (record == this.messageSubscription.getRecord()) {
            messageVariables = BufferUtil.cloneBuffer((DirectBuffer)record.getVariablesBuffer());
        }
        if ((subscription = this.get(record.getElementInstanceKey(), record.getMessageNameBuffer())) == null) {
            throw new IllegalStateException(String.format("Expected subscription but not found. [element-instance-key: %d, message-name: %s]", record.getElementInstanceKey(), record.getMessageName()));
        }
        subscription.getRecord().setMessageKey(messageKey).setVariables(messageVariables);
        this.updateCorrelatingFlag(subscription, true);
        this.transientState.update(new TransientPendingSubscriptionState.PendingSubscription(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageName()), ActorClock.currentTimeMillis());
    }

    @Override
    public void updateToCorrelatedState(MessageSubscription subscription) {
        this.updateCorrelatingFlag(subscription, false);
        this.transientState.remove(new TransientPendingSubscriptionState.PendingSubscription(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageName()));
    }

    @Override
    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        MessageSubscription messageSubscription = (MessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
        boolean bl = found = messageSubscription != null;
        if (found) {
            this.remove(messageSubscription);
        }
        return found;
    }

    @Override
    public void remove(MessageSubscription subscription) {
        this.subscriptionColumnFamily.deleteExisting(this.elementKeyAndMessageName);
        MessageSubscriptionRecord record = subscription.getRecord();
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.deleteExisting(this.nameCorrelationAndElementInstanceKey);
        this.transientState.remove(new TransientPendingSubscriptionState.PendingSubscription(this.elementInstanceKey.getValue(), this.messageName.toString()));
    }

    private void updateCorrelatingFlag(MessageSubscription subscription, boolean correlating) {
        MessageSubscriptionRecord record = subscription.getRecord();
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        subscription.setCorrelating(correlating);
        this.subscriptionColumnFamily.update(this.elementKeyAndMessageName, (DbValue)subscription);
    }

    private Boolean visitMessageSubscription(DbCompositeKey<DbLong, DbString> elementKeyAndMessageName, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        MessageSubscription messageSubscription = (MessageSubscription)this.subscriptionColumnFamily.get(elementKeyAndMessageName);
        if (messageSubscription == null) {
            throw new IllegalStateException(String.format("Expected to find subscription with key %d and %s, but no subscription found", ((DbLong)elementKeyAndMessageName.first()).getValue(), elementKeyAndMessageName.second()));
        }
        return visitor.visit(messageSubscription);
    }

    @Override
    public void visitPending(long deadline, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        for (TransientPendingSubscriptionState.PendingSubscription pendingSubscription : this.transientState.entriesBefore(deadline)) {
            MessageSubscription subscription = this.get(pendingSubscription.elementInstanceKey(), BufferUtil.wrapString((String)pendingSubscription.messageName()));
            visitor.visit(subscription);
        }
    }

    @Override
    public void onSent(long elementInstanceKey, String messageName, long timestampMs) {
        this.transientState.update(new TransientPendingSubscriptionState.PendingSubscription(elementInstanceKey, messageName), timestampMs);
    }
}

