/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class TransientPendingSubscriptionState {
    private final Map<PendingSubscription, Long> pending = new ConcurrentHashMap<PendingSubscription, Long>();

    public void add(PendingSubscription pendingSubscription, long lastSentTime) {
        this.pending.put(pendingSubscription, lastSentTime);
    }

    public void update(PendingSubscription pendingSubscription, long lastSentTime) {
        this.pending.put(pendingSubscription, lastSentTime);
    }

    public void remove(PendingSubscription pendingSubscription) {
        this.pending.remove(pendingSubscription);
    }

    Iterable<PendingSubscription> entriesBefore(long deadline) {
        return this.pending.entrySet().stream().sorted(Map.Entry.comparingByValue()).takeWhile(entry -> (Long)entry.getValue() < deadline).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public record PendingSubscription(long elementInstanceKey, String messageName) {
    }
}

