/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.ProcessEventProcessors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.common.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.CompleteDeploymentDistributionProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionAcknowledgeProcessor;
import io.camunda.zeebe.engine.processing.distribution.CommandRedistributor;
import io.camunda.zeebe.engine.processing.dmn.EvaluateDecisionProcessor;
import io.camunda.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.camunda.zeebe.engine.processing.job.JobEventProcessors;
import io.camunda.zeebe.engine.processing.message.MessageEventProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.resource.ResourceDeletionProcessor;
import io.camunda.zeebe.engine.processing.signal.SignalBroadcastProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.function.Supplier;

public final class EngineProcessors {
    private EngineProcessors() {
    }

    public static TypedRecordProcessors createEngineProcessors(TypedRecordProcessorContext typedRecordProcessorContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, InterPartitionCommandSender interPartitionCommandSender, FeatureFlags featureFlags, JobStreamer jobStreamer) {
        MutableProcessingState processingState = typedRecordProcessorContext.getProcessingState();
        Supplier<ScheduledTaskState> scheduledTaskStateFactory = typedRecordProcessorContext.getScheduledTaskStateFactory();
        Writers writers = typedRecordProcessorContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(processingState.getKeyGenerator(), writers);
        typedRecordProcessors.withListener(processingState);
        int partitionId = typedRecordProcessorContext.getPartitionId();
        EngineConfiguration config = typedRecordProcessorContext.getConfig();
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(scheduledTaskStateFactory.get().getTimerState(), featureFlags);
        JobMetrics jobMetrics = new JobMetrics(partitionId);
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(processingState.getPartitionId());
        subscriptionCommandSender.setWriters(writers);
        DecisionBehavior decisionBehavior = new DecisionBehavior(DecisionEngineFactory.createDecisionEngine(), processingState, processEngineMetrics);
        BpmnBehaviorsImpl bpmnBehaviors = EngineProcessors.createBehaviors(processingState, writers, subscriptionCommandSender, partitionsCount, timerChecker, jobStreamer, jobMetrics, decisionBehavior);
        CommandDistributionBehavior commandDistributionBehavior = new CommandDistributionBehavior(writers, typedRecordProcessorContext.getPartitionId(), partitionsCount, interPartitionCommandSender);
        DeploymentDistributionCommandSender deploymentDistributionCommandSender = new DeploymentDistributionCommandSender(typedRecordProcessorContext.getPartitionId(), interPartitionCommandSender);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(bpmnBehaviors, processingState, scheduledTaskStateFactory, typedRecordProcessors, writers, deploymentDistributionCommandSender, processingState.getKeyGenerator(), featureFlags, commandDistributionBehavior);
        EngineProcessors.addMessageProcessors(bpmnBehaviors, subscriptionCommandSender, processingState, scheduledTaskStateFactory, typedRecordProcessors, writers, config, featureFlags);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(processingState, scheduledTaskStateFactory, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, writers, timerChecker);
        EngineProcessors.addDecisionProcessors(typedRecordProcessors, decisionBehavior, writers, processingState);
        JobEventProcessors.addJobProcessors(typedRecordProcessors, processingState, scheduledTaskStateFactory, bpmnBehaviors, writers, jobMetrics);
        EngineProcessors.addIncidentProcessors(processingState, bpmnStreamProcessor, typedRecordProcessors, writers, bpmnBehaviors.jobActivationBehavior());
        EngineProcessors.addResourceDeletionProcessors(typedRecordProcessors, writers, processingState, commandDistributionBehavior, bpmnBehaviors);
        EngineProcessors.addSignalBroadcastProcessors(typedRecordProcessors, bpmnBehaviors, writers, processingState, commandDistributionBehavior);
        EngineProcessors.addCommandDistributionProcessors(typedRecordProcessors, writers, processingState, scheduledTaskStateFactory, interPartitionCommandSender);
        return typedRecordProcessors;
    }

    private static BpmnBehaviorsImpl createBehaviors(MutableProcessingState processingState, Writers writers, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount, DueDateTimerChecker timerChecker, JobStreamer jobStreamer, JobMetrics jobMetrics, DecisionBehavior decisionBehavior) {
        return new BpmnBehaviorsImpl(processingState, writers, jobMetrics, decisionBehavior, subscriptionCommandSender, partitionsCount, timerChecker, jobStreamer);
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, BpmnBehaviorsImpl bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, Writers writers, DueDateTimerChecker timerChecker) {
        return ProcessEventProcessors.addProcessProcessors(processingState, scheduledTaskState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, timerChecker, writers);
    }

    private static void addDeploymentRelatedProcessorAndServices(BpmnBehaviorsImpl bpmnBehaviors, ProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateSupplier, TypedRecordProcessors typedRecordProcessors, Writers writers, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator, FeatureFlags featureFlags, CommandDistributionBehavior distributionBehavior) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(processingState, bpmnBehaviors, writers, keyGenerator, featureFlags, distributionBehavior);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(deploymentDistributionCommandSender, scheduledTaskStateSupplier.get().getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(processingState, deploymentDistributionCommandSender, writers, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        CompleteDeploymentDistributionProcessor completeDeploymentDistributionProcessor = new CompleteDeploymentDistributionProcessor(processingState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(ProcessingState processingState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers, BpmnJobActivationBehavior jobActivationBehavior) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, processingState, bpmnStreamProcessor, writers, jobActivationBehavior);
    }

    private static void addMessageProcessors(BpmnBehaviorsImpl bpmnBehaviors, SubscriptionCommandSender subscriptionCommandSender, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, TypedRecordProcessors typedRecordProcessors, Writers writers, EngineConfiguration config, FeatureFlags featureFlags) {
        MessageEventProcessors.addMessageProcessors(bpmnBehaviors, typedRecordProcessors, processingState, scheduledTaskStateFactory, subscriptionCommandSender, writers, config, featureFlags);
    }

    private static void addDecisionProcessors(TypedRecordProcessors typedRecordProcessors, DecisionBehavior decisionBehavior, Writers writers, MutableProcessingState processingState) {
        EvaluateDecisionProcessor evaluateDecisionProcessor = new EvaluateDecisionProcessor(decisionBehavior, processingState.getKeyGenerator(), writers);
        typedRecordProcessors.onCommand(ValueType.DECISION_EVALUATION, (Intent)DecisionEvaluationIntent.EVALUATE, evaluateDecisionProcessor);
    }

    private static void addResourceDeletionProcessors(TypedRecordProcessors typedRecordProcessors, Writers writers, MutableProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior, BpmnBehaviors bpmnBehaviors) {
        ResourceDeletionProcessor resourceDeletionProcessor = new ResourceDeletionProcessor(writers, processingState.getKeyGenerator(), processingState, commandDistributionBehavior, bpmnBehaviors);
        typedRecordProcessors.onCommand(ValueType.RESOURCE_DELETION, (Intent)ResourceDeletionIntent.DELETE, resourceDeletionProcessor);
    }

    private static void addSignalBroadcastProcessors(TypedRecordProcessors typedRecordProcessors, BpmnBehaviorsImpl bpmnBehaviors, Writers writers, MutableProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior) {
        SignalBroadcastProcessor signalBroadcastProcessor = new SignalBroadcastProcessor(writers, processingState.getKeyGenerator(), processingState, bpmnBehaviors.stateBehavior(), bpmnBehaviors.eventTriggerBehavior(), commandDistributionBehavior);
        typedRecordProcessors.onCommand(ValueType.SIGNAL, (Intent)SignalIntent.BROADCAST, signalBroadcastProcessor);
    }

    private static void addCommandDistributionProcessors(TypedRecordProcessors typedRecordProcessors, Writers writers, ProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, InterPartitionCommandSender interPartitionCommandSender) {
        typedRecordProcessors.withListener(new CommandRedistributor(scheduledTaskStateFactory.get().getDistributionState(), interPartitionCommandSender));
        CommandDistributionAcknowledgeProcessor commandDistributionAcknowledgeProcessor = new CommandDistributionAcknowledgeProcessor(processingState.getDistributionState(), writers);
        typedRecordProcessors.onCommand(ValueType.COMMAND_DISTRIBUTION, (Intent)CommandDistributionIntent.ACKNOWLEDGE, commandDistributionAcknowledgeProcessor);
    }
}

