/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.agrona.DirectBuffer;

public final class UnsupportedMultiTenantFeaturesValidator {
    private static final EnumSet<BpmnElementType> REJECTED_ELEMENT_TYPES = EnumSet.noneOf(BpmnElementType.class);
    private static final EnumSet<BpmnEventType> UNSUPPORTED_EVENT_TYPES = EnumSet.of(BpmnEventType.SIGNAL);

    public static Either<Failure, ?> validate(DeploymentResource resource, List<ExecutableProcess> executableProcesses, String tenantId) {
        if (Objects.equals(tenantId, "<default>")) {
            return Either.right(null);
        }
        ArrayList failures = new ArrayList();
        executableProcesses.forEach(executableProcess -> UnsupportedMultiTenantFeaturesValidator.hasUnsupportedElement(resource, executableProcess).ifLeft(failures::add));
        if (failures.isEmpty()) {
            return Either.right(null);
        }
        StringWriter writer = new StringWriter();
        failures.forEach(failure -> writer.write(failure.getMessage()));
        return Either.left((Object)new Failure(writer.toString()));
    }

    private static Either<Failure, ?> hasUnsupportedElement(DeploymentResource resource, ExecutableProcess executableProcess) {
        List<ExecutableFlowNode> unsupportedElementsInProcess = UnsupportedMultiTenantFeaturesValidator.findUnsupportedElementsInProcess(executableProcess);
        if (unsupportedElementsInProcess.isEmpty()) {
            return Either.right(null);
        }
        String failureMessage = UnsupportedMultiTenantFeaturesValidator.createFailureMessage(resource, executableProcess, unsupportedElementsInProcess);
        return Either.left((Object)new Failure(failureMessage));
    }

    private static List<ExecutableFlowNode> findUnsupportedElementsInProcess(ExecutableProcess executableProcess) {
        return executableProcess.getFlowElements().stream().map(flowElement -> flowElement instanceof ExecutableMultiInstanceBody ? ((ExecutableMultiInstanceBody)flowElement).getInnerActivity() : flowElement).filter(flowElement -> REJECTED_ELEMENT_TYPES.contains(flowElement.getElementType()) || UNSUPPORTED_EVENT_TYPES.contains(flowElement.getEventType())).map(ExecutableFlowNode.class::cast).sorted(Comparator.comparing(AbstractFlowElement::getId)).toList();
    }

    private static String createFailureMessage(DeploymentResource resource, ExecutableProcess executableProcess, List<ExecutableFlowNode> unsupportedElements) {
        List<ElementInfo> unsupportedElementsInfo = unsupportedElements.stream().map(ElementInfo::new).toList();
        String failureMessage = "Processes belonging to custom tenants are not allowed to contain elements unsupported with multi-tenancy. Only the default tenant '<default>' supports these elements currently: %s. See https://github.com/camunda/zeebe/issues/12653 for more details.".formatted(String.join((CharSequence)" > ", unsupportedElementsInfo.toString()));
        return UnsupportedMultiTenantFeaturesValidator.createFormattedFailureMessage(resource, executableProcess, failureMessage);
    }

    private static String createFormattedFailureMessage(DeploymentResource resource, ExecutableProcess executableProcess, String message) {
        StringWriter writer = new StringWriter();
        writer.write(String.format("`%s`: - Process: %s", resource.getResourceName(), BufferUtil.bufferAsString((DirectBuffer)executableProcess.getId())));
        writer.write("\n");
        writer.write("    - ERROR: ");
        writer.write(message);
        writer.write("\n");
        return writer.toString();
    }

    record ElementInfo(DirectBuffer id, BpmnElementType elementType, BpmnEventType eventType) {
        public ElementInfo(AbstractFlowElement element) {
            this(element.getId(), element.getElementType(), element.getEventType());
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("'%s'".formatted(BufferUtil.bufferAsString((DirectBuffer)this.id)));
            if (this.eventType == null || this.eventType == BpmnEventType.UNSPECIFIED) {
                builder.append(" of type '%s'".formatted(this.elementType));
            } else {
                builder.append(" of type '%s' '%s'".formatted(this.eventType, this.elementType));
            }
            return builder.toString();
        }
    }
}

