/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.metrics.BufferedMessagesMetrics;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableBoolean;

public final class DbMessageState
implements MutableMessageState {
    private static final String DEADLINE_MESSAGE_COUNT_KEY = "deadline_message_count";
    private final ColumnFamily<DbLong, StoredMessage> messageColumnFamily;
    private final DbLong messageKey = new DbLong();
    private final DbForeignKey<DbLong> fkMessage = new DbForeignKey((DbKey)this.messageKey, (Enum)ZbColumnFamilies.MESSAGE_KEY);
    private final StoredMessage message = new StoredMessage();
    private final DbString tenantIdKey;
    private final DbString messageName;
    private final DbTenantAwareKey<DbString> tenantAwareMessageName;
    private final DbString correlationKey;
    private final DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>> nameCorrelationMessageKey;
    private final DbCompositeKey<DbTenantAwareKey<DbString>, DbString> nameAndCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>>, DbNil> nameCorrelationMessageColumnFamily;
    private final DbLong deadline;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineMessageKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlineColumnFamily;
    private final DbLong messagesDeadlineCount;
    private final DbString messagesDeadlineCountKey;
    private final ColumnFamily<DbString, DbLong> messagesDeadlineCountColumnFamily;
    private final DbString messageId;
    private final DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbString> nameCorrelationMessageIdKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbString>, DbNil> messageIdColumnFamily;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbString> messageBpmnProcessIdKey;
    private final DbString bpmnProcessIdKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbString>, DbNil> correlatedMessageColumnFamily;
    private final DbCompositeKey<DbString, DbString> bpmnProcessIdCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbString>, DbNil> activeProcessInstancesByCorrelationKeyColumnFamily;
    private final DbLong processInstanceKey;
    private final ColumnFamily<DbLong, DbString> processInstanceCorrelationKeyColumnFamily;
    private final BufferedMessagesMetrics bufferedMessagesMetrics;
    private Long localMessageDeadlineCount = 0L;

    public DbMessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.messageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_KEY, transactionContext, (DbKey)this.messageKey, (DbValue)this.message);
        this.tenantIdKey = new DbString();
        this.messageName = new DbString();
        this.tenantAwareMessageName = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey(this.tenantAwareMessageName, (DbKey)this.correlationKey);
        this.nameCorrelationMessageKey = new DbCompositeKey(this.nameAndCorrelationKey, this.fkMessage);
        this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGES, transactionContext, this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline = new DbLong();
        this.deadlineMessageKey = new DbCompositeKey((DbKey)this.deadline, this.fkMessage);
        this.deadlineColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_DEADLINES, transactionContext, this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        this.messagesDeadlineCount = new DbLong();
        this.messagesDeadlineCountKey = new DbString();
        this.messagesDeadlineCountColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_STATS, transactionContext, (DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
        this.messagesDeadlineCountKey.wrapString(DEADLINE_MESSAGE_COUNT_KEY);
        this.messageId = new DbString();
        this.nameCorrelationMessageIdKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.messageId);
        this.messageIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_IDS, transactionContext, this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        this.bpmnProcessIdKey = new DbString();
        this.messageBpmnProcessIdKey = new DbCompositeKey(this.fkMessage, (DbKey)this.bpmnProcessIdKey);
        this.correlatedMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_CORRELATED, transactionContext, this.messageBpmnProcessIdKey, (DbValue)DbNil.INSTANCE);
        this.bpmnProcessIdCorrelationKey = new DbCompositeKey((DbKey)this.bpmnProcessIdKey, (DbKey)this.correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_PROCESSES_ACTIVE_BY_CORRELATION_KEY, transactionContext, this.bpmnProcessIdCorrelationKey, (DbValue)DbNil.INSTANCE);
        this.processInstanceKey = new DbLong();
        this.processInstanceCorrelationKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_PROCESS_INSTANCE_CORRELATION_KEYS, transactionContext, (DbKey)this.processInstanceKey, (DbValue)this.correlationKey);
        this.bufferedMessagesMetrics = new BufferedMessagesMetrics(partitionId);
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        if (!this.messagesDeadlineCountColumnFamily.isEmpty()) {
            this.localMessageDeadlineCount = ((DbLong)this.messagesDeadlineCountColumnFamily.get((DbKey)this.messagesDeadlineCountKey)).getValue();
        }
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
    }

    @Override
    public void put(long key, MessageRecord record) {
        this.messageKey.wrapLong(key);
        this.message.setMessageKey(key).setMessage(record);
        this.messageColumnFamily.insert((DbKey)this.messageKey, (DbValue)this.message);
        this.tenantIdKey.wrapString(record.getTenantId());
        this.messageName.wrapBuffer(record.getNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.insert(this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline.wrapLong(record.getDeadline());
        this.deadlineColumnFamily.insert(this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        this.localMessageDeadlineCount = this.localMessageDeadlineCount + 1L;
        this.messagesDeadlineCount.wrapLong(this.localMessageDeadlineCount.longValue());
        this.messagesDeadlineCountColumnFamily.upsert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
        DirectBuffer messageId = record.getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.upsert(this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        }
    }

    @Override
    public void putMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.insert(this.messageBpmnProcessIdKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.deleteIfExists(this.messageBpmnProcessIdKey);
    }

    @Override
    public void putActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily.insert(this.bpmnProcessIdCorrelationKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily.deleteExisting(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public void putProcessInstanceCorrelationKey(long processInstanceKey, DirectBuffer correlationKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.correlationKey.wrapBuffer(correlationKey);
        this.processInstanceCorrelationKeyColumnFamily.insert((DbKey)this.processInstanceKey, (DbValue)this.correlationKey);
    }

    @Override
    public void removeProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.processInstanceCorrelationKeyColumnFamily.deleteExisting((DbKey)this.processInstanceKey);
    }

    @Override
    public void remove(long key) {
        StoredMessage storedMessage = this.getMessage(key);
        if (storedMessage == null) {
            return;
        }
        this.messageKey.wrapLong(storedMessage.getMessageKey());
        this.messageColumnFamily.deleteExisting((DbKey)this.messageKey);
        this.tenantIdKey.wrapString(storedMessage.getMessage().getTenantId());
        this.messageName.wrapBuffer(storedMessage.getMessage().getNameBuffer());
        this.correlationKey.wrapBuffer(storedMessage.getMessage().getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.deleteExisting(this.nameCorrelationMessageKey);
        DirectBuffer messageId = storedMessage.getMessage().getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.deleteExisting(this.nameCorrelationMessageIdKey);
        }
        this.deadline.wrapLong(storedMessage.getMessage().getDeadline());
        this.deadlineColumnFamily.deleteExisting(this.deadlineMessageKey);
        this.localMessageDeadlineCount = this.localMessageDeadlineCount - 1L;
        this.messagesDeadlineCount.wrapLong(this.localMessageDeadlineCount.longValue());
        this.messagesDeadlineCountColumnFamily.upsert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
        this.correlatedMessageColumnFamily.whileEqualPrefix((DbKey)this.messageKey, (compositeKey, zbNil) -> this.correlatedMessageColumnFamily.deleteExisting((DbKey)compositeKey));
    }

    @Override
    public boolean existMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        return this.correlatedMessageColumnFamily.exists(this.messageBpmnProcessIdKey);
    }

    @Override
    public boolean existActiveProcessInstance(String tenantId, DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        return this.activeProcessInstancesByCorrelationKeyColumnFamily.exists(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public DirectBuffer getProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        DbString correlationKey = (DbString)this.processInstanceCorrelationKeyColumnFamily.get((DbKey)this.processInstanceKey);
        return correlationKey != null ? correlationKey.getBuffer() : null;
    }

    @Override
    public void visitMessages(String tenantId, DirectBuffer name, DirectBuffer correlationKey, MessageState.MessageVisitor visitor) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.nameCorrelationMessageColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> {
            long messageKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
            StoredMessage message = this.getMessage(messageKey);
            return visitor.visit(message);
        });
    }

    @Override
    public StoredMessage getMessage(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return (StoredMessage)this.messageColumnFamily.get((DbKey)this.messageKey);
    }

    @Override
    public boolean visitMessagesWithDeadlineBeforeTimestamp(long timestamp, MessageState.Index startAt, MessageState.ExpiredMessageVisitor visitor) {
        DbCompositeKey<DbLong, DbForeignKey<DbLong>> startAtKey;
        if (startAt != null) {
            this.deadline.wrapLong(startAt.deadline());
            this.messageKey.wrapLong(startAt.key());
            startAtKey = this.deadlineMessageKey;
        } else {
            startAtKey = null;
        }
        MutableBoolean stoppedByVisitor = new MutableBoolean(false);
        this.deadlineColumnFamily.whileTrue(startAtKey, (key, value) -> {
            boolean shouldContinue = false;
            long deadlineEntry = ((DbLong)key.first()).getValue();
            if (deadlineEntry <= timestamp) {
                long messageKeyEntry = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                shouldContinue = visitor.visit(deadlineEntry, messageKeyEntry);
                stoppedByVisitor.set(!shouldContinue);
            }
            return shouldContinue;
        });
        return stoppedByVisitor.get();
    }

    @Override
    public boolean exist(DirectBuffer name, DirectBuffer correlationKey, DirectBuffer messageId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageId.wrapBuffer(messageId);
        return this.messageIdColumnFamily.exists(this.nameCorrelationMessageIdKey);
    }
}

