/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.variable;

import io.camunda.zeebe.engine.state.variable.DocumentEntry;
import io.camunda.zeebe.engine.state.variable.DocumentEntryIterator;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public final class IndexedDocument
implements Iterable<DocumentEntry> {
    private final MsgPackReader reader;
    private final Int2IntHashMap entries = new Int2IntHashMap(-1);
    private final DocumentEntryIterator iterator = new DocumentEntryIterator();
    private final DirectBuffer document = new UnsafeBuffer();

    public IndexedDocument() {
        this(new MsgPackReader());
    }

    public IndexedDocument(MsgPackReader reader) {
        this.reader = reader;
    }

    public void index(DirectBuffer document) {
        this.document.wrap(document);
        this.entries.clear();
        this.reader.wrap(document, 0, document.capacity());
        int variables = this.reader.readMapHeader();
        for (int i = 0; i < variables; ++i) {
            int keyOffset = this.reader.getOffset();
            this.reader.skipValue();
            int valueOffset = this.reader.getOffset();
            this.reader.skipValue();
            this.entries.put(keyOffset, valueOffset);
        }
    }

    public DocumentEntryIterator iterator() {
        this.iterator.wrap(this.document, this.entries.entrySet().iterator());
        return this.iterator;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }
}

