/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnUserTaskBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskSupportingProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class UserTaskProcessor
extends JobWorkerTaskSupportingProcessor<ExecutableUserTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnUserTaskBehavior userTaskBehavior;
    private final BpmnStateBehavior stateBehavior;

    public UserTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        super(bpmnBehaviors, stateTransitionBehavior);
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.userTaskBehavior = bpmnBehaviors.userTaskBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
    }

    @Override
    public Class<ExecutableUserTask> getType() {
        return ExecutableUserTask.class;
    }

    @Override
    protected boolean isJobBehavior(ExecutableUserTask element, BpmnElementContext context) {
        if (element.getUserTaskProperties() != null) {
            return false;
        }
        if (element.getJobWorkerProperties() == null) {
            throw new BpmnProcessingException(context, "Expected to process user task, but could not determine processing behavior");
        }
        return true;
    }

    @Override
    protected void onActivateInternal(ExecutableUserTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.userTaskBehavior.evaluateUserTaskExpressions(element, context)).flatMap(j -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> j)).ifRightOrLeft(userTaskProperties -> {
            long userTaskKey = this.userTaskBehavior.createNewUserTask(context, element, (BpmnUserTaskBehavior.UserTaskProperties)userTaskProperties);
            this.userTaskBehavior.userTaskCreated(userTaskKey, context, element, (BpmnUserTaskBehavior.UserTaskProperties)userTaskProperties);
            this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    protected void onCompleteInternal(ExecutableUserTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    protected void onTerminateInternal(ExecutableUserTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.userTaskBehavior.cancelUserTask(context);
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

