/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Signal;

public final class SignalTransformer
implements ModelElementTransformer<Signal> {
    @Override
    public Class<Signal> getType() {
        return Signal.class;
    }

    @Override
    public void transform(Signal element, TransformContext context) {
        String id = element.getId();
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        ExecutableSignal executableElement = new ExecutableSignal(id);
        if (element.getName() != null) {
            EvaluationResult signalNameResult;
            Expression signalNameExpression = expressionLanguage.parseExpression(element.getName());
            executableElement.setSignalNameExpression(signalNameExpression);
            if (signalNameExpression.isStatic() && (signalNameResult = expressionLanguage.evaluateExpression(signalNameExpression, variable -> null)).getType() == ResultType.STRING) {
                String signalName = signalNameResult.getString();
                executableElement.setSignalName(signalName);
            }
            context.addSignal(executableElement);
        }
    }
}

