/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class VariableMappingTransformer {
    private static final String EXPRESSION_MARKER = "=";

    public Expression transformInputMappings(Collection<? extends ZeebeMapping> inputMappings, ExpressionLanguage expressionLanguage) {
        List<Mapping> mappings = this.toMappings(inputMappings, expressionLanguage);
        MappingContext context = this.asContext(mappings);
        String contextExpression = this.asFeelContextExpression(context, (contextValue, contextPath) -> contextValue);
        return this.parseExpression(contextExpression, expressionLanguage);
    }

    public Expression transformOutputMappings(Collection<? extends ZeebeMapping> outputMappings, ExpressionLanguage expressionLanguage) {
        List<Mapping> mappings = this.toMappings(outputMappings, expressionLanguage);
        MappingContext context = this.asContext(mappings);
        String contextExpression = this.asFeelContextExpression(context, this::mergeContextExpression);
        return this.parseExpression(contextExpression, expressionLanguage);
    }

    private List<Mapping> toMappings(Collection<? extends ZeebeMapping> mappings, ExpressionLanguage expressionLanguage) {
        return mappings.stream().map(mapping -> {
            String source = mapping.getSource();
            Expression sourceExpression = expressionLanguage.parseExpression(source);
            return new Mapping(sourceExpression, mapping.getTarget());
        }).collect(Collectors.toList());
    }

    private MappingContext asContext(List<Mapping> mappings) {
        MappingContext context = new MappingContext();
        for (Mapping mapping : mappings) {
            Expression sourceExpression = mapping.source;
            String targetPathExpression = mapping.target;
            List<String> targetPathParts = this.splitPathExpression(targetPathExpression);
            this.createContextEntry(targetPathParts, sourceExpression, context);
        }
        return context;
    }

    private List<String> splitPathExpression(String path) {
        String[] parts = path.split("\\.");
        return new ArrayList<String>(Arrays.asList(parts));
    }

    private void createContextEntry(List<String> targetPathParts, Expression sourceExpression, MappingContext context) {
        String target = targetPathParts.remove(0);
        if (targetPathParts.isEmpty()) {
            context.addEntry(target, sourceExpression);
        } else {
            MappingContext nestedContext = context.getOrAddContext(target);
            this.createContextEntry(targetPathParts, sourceExpression, nestedContext);
        }
    }

    private String asFeelContextExpression(MappingContext context, BiFunction<String, List<String>, Object> contextValueVisitor) {
        return context.visit(this.feelContextBuilder(contextValueVisitor));
    }

    private MappingContextVisitor<String> feelContextBuilder(final BiFunction<String, List<String>, Object> contextValueVisitor) {
        return new MappingContextVisitor<String>(this){

            @Override
            public String onEntry(String targetKey, Expression sourceExpression) {
                String expression = sourceExpression instanceof StaticExpression ? String.format("\"%s\"", sourceExpression.getExpression()) : sourceExpression.getExpression();
                return targetKey + ":" + expression;
            }

            @Override
            public String onContext(List<String> entries) {
                return "{" + String.join((CharSequence)",", entries) + "}";
            }

            @Override
            public String onContextEntry(String targetKey, String contextValue, List<String> contextPath) {
                return targetKey + ":" + String.valueOf(contextValueVisitor.apply(contextValue, contextPath));
            }
        };
    }

    private String mergeContextExpression(String nestedContext, List<String> contextPath) {
        String existingContext = String.join((CharSequence)".", contextPath);
        return String.format("if (%s != null) then context merge(%s,%s) else %s", existingContext, existingContext, nestedContext, nestedContext);
    }

    private Expression parseExpression(String contextExpression, ExpressionLanguage expressionLanguage) {
        Expression expression = expressionLanguage.parseExpression(EXPRESSION_MARKER + contextExpression);
        if (!expression.isValid()) {
            throw new IllegalStateException(String.format("Failed to build variable mapping expression: %s", expression.getFailureMessage()));
        }
        return expression;
    }

    private static final class MappingContext {
        private final Map<String, Object> entries = new LinkedHashMap<String, Object>();
        private final List<String> path;

        public MappingContext() {
            this.path = new ArrayList<String>();
        }

        public MappingContext(List<String> path) {
            this.path = path;
        }

        public void addEntry(String key, Expression value) {
            this.entries.put(key, value);
        }

        public MappingContext getOrAddContext(String key) {
            Object entry = this.entries.get(key);
            if (entry instanceof MappingContext) {
                return (MappingContext)entry;
            }
            ArrayList<String> nestedPath = new ArrayList<String>(this.path);
            nestedPath.add(key);
            MappingContext nestedContext = new MappingContext(nestedPath);
            this.entries.put(key, nestedContext);
            return nestedContext;
        }

        public <T> T visit(MappingContextVisitor<T> visitor) {
            List entries = this.entries.entrySet().stream().map(entry -> {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof MappingContext) {
                    MappingContext nestedContext = (MappingContext)value;
                    Object contextValue = nestedContext.visit(visitor);
                    return visitor.onContextEntry(key, contextValue, nestedContext.path);
                }
                return visitor.onEntry(key, (Expression)value);
            }).collect(Collectors.toList());
            return visitor.onContext(entries);
        }
    }

    private static final class Mapping {
        private final Expression source;
        private final String target;

        private Mapping(Expression source, String target) {
            this.source = source;
            this.target = target;
        }
    }

    private static interface MappingContextVisitor<T> {
        public T onEntry(String var1, Expression var2);

        public T onContext(List<T> var1);

        public T onContextEntry(String var1, T var2, List<String> var3);
    }
}

