/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.util.Optional;

public final class TaskDefinitionTransformer {
    public void transform(ExecutableJobWorkerElement element, TransformContext context, ZeebeTaskDefinition taskDefinition) {
        if (taskDefinition == null) {
            return;
        }
        JobWorkerProperties jobWorkerProperties = Optional.ofNullable(element.getJobWorkerProperties()).orElse(new JobWorkerProperties());
        element.setJobWorkerProperties(jobWorkerProperties);
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        Expression jobTypeExpression = expressionLanguage.parseExpression(taskDefinition.getType());
        jobWorkerProperties.setType(jobTypeExpression);
        Expression retriesExpression = expressionLanguage.parseExpression(taskDefinition.getRetries());
        jobWorkerProperties.setRetries(retriesExpression);
    }
}

