/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.usertask.UserTaskCommandPreconditionChecker;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.List;

public class UserTaskClaimProcessor
implements TypedRecordProcessor<UserTaskRecord> {
    private final UserTaskState userTaskState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final UserTaskCommandPreconditionChecker preconditionChecker;

    public UserTaskClaimProcessor(ProcessingState state, Writers writers) {
        this.userTaskState = state.getUserTaskState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.preconditionChecker = new UserTaskCommandPreconditionChecker(List.of(UserTaskState.LifecycleState.CREATED), "claim", this.userTaskState);
    }

    @Override
    public void processRecord(TypedRecord<UserTaskRecord> command) {
        this.preconditionChecker.check(command).ifRightOrLeft(persistedRecord -> this.claimUserTask(command, (UserTaskRecord)persistedRecord), violation -> {
            this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)command, (RejectionType)violation.getLeft(), (String)violation.getRight());
            this.responseWriter.writeRejectionOnCommand(command, (RejectionType)violation.getLeft(), (String)violation.getRight());
        });
    }

    private void claimUserTask(TypedRecord<UserTaskRecord> command, UserTaskRecord userTaskRecord) {
        long userTaskKey = command.getKey();
        userTaskRecord.setAssignee(((UserTaskRecord)command.getValue()).getAssignee());
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.ASSIGNING, (RecordValue)userTaskRecord);
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.ASSIGNED, (RecordValue)userTaskRecord);
        this.responseWriter.writeEventOnCommand(userTaskKey, (Intent)UserTaskIntent.ASSIGNED, (UnpackedObject)userTaskRecord, command);
    }
}

