/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyJobState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbJobMigrationState {
    private final LegacyJobState from;
    private final DbJobState to;

    public DbJobMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacyJobState(zeebeDb, transactionContext);
        this.to = new DbJobState(zeebeDb, transactionContext);
    }

    public void migrateJobStateForMultiTenancy() {
        this.to.tenantIdKey.wrapString("<default>");
        this.from.getActivatableColumnFamily().forEach((key, value) -> {
            this.to.jobTypeKey.wrapString(((DbString)key.first()).toString());
            ((DbLong)this.to.fkJob.inner()).wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            this.to.activatableColumnFamily.insert(this.to.tenantAwareTypeJobKey, (DbValue)DbNil.INSTANCE);
            this.from.getActivatableColumnFamily().deleteExisting((DbKey)key);
        });
    }

    private static final class DbJobState {
        private final DbLong jobKey = new DbLong();
        private final DbForeignKey<DbLong> fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        private final DbString jobTypeKey = new DbString();
        private final DbString tenantIdKey = new DbString();
        private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey = new DbCompositeKey((DbKey)this.jobTypeKey, this.fkJob);
        private final DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>> tenantAwareTypeJobKey = new DbTenantAwareKey(this.tenantIdKey, this.typeJobKey, DbTenantAwareKey.PlacementType.SUFFIX);
        private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>, DbNil> activatableColumnFamily;

        public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.activatableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.tenantAwareTypeJobKey, (DbValue)DbNil.INSTANCE);
        }
    }
}

