/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbMessageMigrationState {
    private final LegacyMessageState from;
    private final DbMessageState to;

    public DbMessageMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        int partitionId = -1;
        this.from = new LegacyMessageState(zeebeDb, transactionContext, -1);
        this.to = new DbMessageState(zeebeDb, transactionContext);
    }

    public void migrateMessageStateForMultiTenancy() {
        this.to.tenantIdKey.wrapString("<default>");
        this.from.getNameCorrelationMessageColumnFamily().forEach((key, value) -> {
            this.to.messageName.wrapBuffer(((DbString)((DbCompositeKey)key.first()).first()).getBuffer());
            this.to.correlationKey.wrapBuffer(((DbString)((DbCompositeKey)key.first()).second()).getBuffer());
            this.to.messageKey.wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            this.to.nameCorrelationMessageColumnFamily.insert(this.to.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
            this.from.getNameCorrelationMessageColumnFamily().deleteExisting((DbKey)key);
        });
    }

    private static final class DbMessageState {
        private final DbLong messageKey = new DbLong();
        private final DbForeignKey<DbLong> fkMessage = new DbForeignKey((DbKey)this.messageKey, (Enum)ZbColumnFamilies.MESSAGE_KEY);
        private final DbString tenantIdKey = new DbString();
        private final DbString messageName = new DbString();
        private final DbTenantAwareKey<DbString> tenantAwareMessageName = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
        private final DbString correlationKey = new DbString();
        private final DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>> nameCorrelationMessageKey;
        private final DbCompositeKey<DbTenantAwareKey<DbString>, DbString> nameAndCorrelationKey = new DbCompositeKey(this.tenantAwareMessageName, (DbKey)this.correlationKey);
        private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>>, DbNil> nameCorrelationMessageColumnFamily;

        public DbMessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.nameCorrelationMessageKey = new DbCompositeKey(this.nameAndCorrelationKey, this.fkMessage);
            this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGES, transactionContext, this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        }
    }
}

