/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import com.google.common.base.Strings;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnUserTaskBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BpmnJobBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BpmnJobBehavior.class.getPackageName());
    private static final Set<JobState.State> CANCELABLE_STATES = EnumSet.of(JobState.State.ACTIVATABLE, JobState.State.ACTIVATED, JobState.State.FAILED, JobState.State.ERROR_THROWN);
    private final JobRecord jobRecord = new JobRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final HeaderEncoder headerEncoder = new HeaderEncoder();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final JobState jobState;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final JobMetrics jobMetrics;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final BpmnUserTaskBehavior userTaskBehavior;

    public BpmnJobBehavior(KeyGenerator keyGenerator, JobState jobState, Writers writers, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior, BpmnIncidentBehavior incidentBehavior, BpmnJobActivationBehavior jobActivationBehavior, JobMetrics jobMetrics, BpmnUserTaskBehavior userTaskBehavior) {
        this.keyGenerator = keyGenerator;
        this.jobState = jobState;
        this.expressionBehavior = expressionBehavior;
        this.stateWriter = writers.state();
        this.stateBehavior = stateBehavior;
        this.incidentBehavior = incidentBehavior;
        this.jobMetrics = jobMetrics;
        this.jobActivationBehavior = jobActivationBehavior;
        this.userTaskBehavior = userTaskBehavior;
    }

    public Either<Failure, JobProperties> evaluateJobExpressions(ExecutableJobWorkerElement element, BpmnElementContext context) {
        JobWorkerProperties jobWorkerProps = element.getJobWorkerProperties();
        long scopeKey = context.getElementInstanceKey();
        String tenantId = context.getTenantId();
        return Either.right((Object)new JobProperties()).flatMap(p -> this.evalTypeExp(jobWorkerProps.getType(), scopeKey).map(p::type)).flatMap(p -> this.evalRetriesExp(jobWorkerProps.getRetries(), scopeKey).map(p::retries)).flatMap(p -> this.userTaskBehavior.evaluateAssigneeExpression(jobWorkerProps.getAssignee(), scopeKey).map(p::assignee)).flatMap(p -> this.userTaskBehavior.evaluateCandidateGroupsExpression(jobWorkerProps.getCandidateGroups(), scopeKey).map(p::candidateGroups)).flatMap(p -> this.userTaskBehavior.evaluateCandidateUsersExpression(jobWorkerProps.getCandidateUsers(), scopeKey).map(p::candidateUsers)).flatMap(p -> this.userTaskBehavior.evaluateDateExpression(jobWorkerProps.getDueDate(), scopeKey).map(p::dueDate)).flatMap(p -> this.userTaskBehavior.evaluateDateExpression(jobWorkerProps.getFollowUpDate(), scopeKey).map(p::followUpDate)).flatMap(p -> this.userTaskBehavior.evaluateFormIdExpressionToFormKey(jobWorkerProps.getFormId(), scopeKey, tenantId).map(key -> Objects.toString(key, null)).map(p::formKey));
    }

    public void createNewJob(BpmnElementContext context, ExecutableJobWorkerElement element, JobProperties jobProperties) {
        this.writeJobCreatedEvent(context, element, jobProperties);
        this.jobMetrics.jobCreated(jobProperties.getType());
    }

    private Either<Failure, String> evalTypeExp(Expression type, long scopeKey) {
        return this.expressionBehavior.evaluateStringExpression(type, scopeKey).flatMap(result -> Strings.isNullOrEmpty((String)result) ? Either.left((Object)new Failure(String.format("Expected result of the expression '%s' to be a not-empty string, but was an empty string.", type.getExpression()), ErrorType.EXTRACT_VALUE_ERROR, scopeKey)) : Either.right((Object)result));
    }

    private Either<Failure, Long> evalRetriesExp(Expression retries, long scopeKey) {
        return this.expressionBehavior.evaluateLongExpression(retries, scopeKey);
    }

    private void writeJobCreatedEvent(BpmnElementContext context, ExecutableJobWorkerElement jobWorkerElement, JobProperties props) {
        Map<String, String> taskHeaders = jobWorkerElement.getJobWorkerProperties().getTaskHeaders();
        DirectBuffer encodedHeaders = this.encodeHeaders(taskHeaders, props);
        this.jobRecord.setType(props.getType()).setRetries(props.getRetries().intValue()).setCustomHeaders(encodedHeaders).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(jobWorkerElement.getId()).setElementInstanceKey(context.getElementInstanceKey()).setTenantId(context.getTenantId());
        long jobKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CREATED, (RecordValue)this.jobRecord);
        this.jobActivationBehavior.publishWork(jobKey, this.jobRecord);
    }

    private DirectBuffer encodeHeaders(Map<String, String> taskHeaders, JobProperties props) {
        HashMap<String, String> headers = new HashMap<String, String>(taskHeaders);
        String assignee = props.getAssignee();
        String candidateGroups = props.getCandidateGroups();
        String candidateUsers = props.getCandidateUsers();
        String dueDate = props.getDueDate();
        String followUpDate = props.getFollowUpDate();
        String formKey = props.getFormKey();
        if (assignee != null && !assignee.isEmpty()) {
            headers.put("io.camunda.zeebe:assignee", assignee);
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            headers.put("io.camunda.zeebe:candidateGroups", candidateGroups);
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            headers.put("io.camunda.zeebe:candidateUsers", candidateUsers);
        }
        if (dueDate != null && !dueDate.isEmpty()) {
            headers.put("io.camunda.zeebe:dueDate", dueDate);
        }
        if (followUpDate != null && !followUpDate.isEmpty()) {
            headers.put("io.camunda.zeebe:followUpDate", followUpDate);
        }
        if (formKey != null && !formKey.isEmpty()) {
            headers.put("io.camunda.zeebe:formKey", formKey);
        }
        return this.headerEncoder.encode(headers);
    }

    public void cancelJob(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        this.cancelJob(elementInstance);
    }

    public void cancelJob(ElementInstance elementInstance) {
        long jobKey = elementInstance.getJobKey();
        if (jobKey > 0L) {
            this.writeJobCanceled(jobKey);
            this.incidentBehavior.resolveJobIncident(jobKey);
        }
    }

    private void writeJobCanceled(long jobKey) {
        JobState.State state = this.jobState.getState(jobKey);
        if (CANCELABLE_STATES.contains((Object)state)) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CANCELED, (RecordValue)job);
            this.jobMetrics.jobCanceled(job.getType());
        }
    }

    private static final class HeaderEncoder {
        private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
        private final MsgPackWriter msgPackWriter = new MsgPackWriter();

        private HeaderEncoder() {
        }

        public DirectBuffer encode(Map<String, String> taskHeaders) {
            if (taskHeaders == null || taskHeaders.isEmpty()) {
                return JobRecord.NO_HEADERS;
            }
            UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
            Map<String, String> validHeaders = taskHeaders.entrySet().stream().filter(entry -> this.isValidHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (validHeaders.size() != taskHeaders.size()) {
                LOGGER.debug("Ignored {} invalid headers.", (Object)(taskHeaders.size() - validHeaders.size()));
            }
            ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * validHeaders.size());
            this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
            this.msgPackWriter.writeMapHeader(validHeaders.size());
            validHeaders.forEach((k, v) -> {
                DirectBuffer key = BufferUtil.wrapString((String)k);
                this.msgPackWriter.writeString(key);
                DirectBuffer value = BufferUtil.wrapString((String)v);
                this.msgPackWriter.writeString(value);
            });
            buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
            return buffer;
        }

        private boolean isValidHeader(String key, String value) {
            return key != null && !key.isEmpty() && value != null && !value.isEmpty();
        }
    }

    public static final class JobProperties {
        private String type;
        private Long retries;
        private String assignee;
        private String candidateGroups;
        private String candidateUsers;
        private String dueDate;
        private String followUpDate;
        private String formKey;

        public JobProperties type(String type) {
            this.type = type;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public JobProperties retries(Long retries) {
            this.retries = retries;
            return this;
        }

        public Long getRetries() {
            return this.retries;
        }

        public JobProperties assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public String getAssignee() {
            return this.assignee;
        }

        public JobProperties candidateGroups(String candidateGroups) {
            this.candidateGroups = candidateGroups;
            return this;
        }

        public String getCandidateGroups() {
            return this.candidateGroups;
        }

        public JobProperties candidateUsers(String candidateUsers) {
            this.candidateUsers = candidateUsers;
            return this;
        }

        public String getCandidateUsers() {
            return this.candidateUsers;
        }

        public JobProperties dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public String getDueDate() {
            return this.dueDate;
        }

        public JobProperties followUpDate(String followUpDate) {
            this.followUpDate = followUpDate;
            return this;
        }

        public String getFollowUpDate() {
            return this.followUpDate;
        }

        public JobProperties formKey(String formId) {
            this.formKey = formId;
            return this;
        }

        public String getFormKey() {
            return this.formKey;
        }
    }
}

