/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.deployment.VersionInfo;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.TemporaryVariables;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbDecisionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbJobMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageStartEventSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbProcessMessageSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbProcessMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_4.DbColumnFamilyCorrectionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_4.DbSignalSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class DbMigrationState
implements MutableMigrationState {
    private static final long NO_PARENT_KEY = -1L;
    private final DbLong messageSubscriptionSentTime;
    private final DbLong messageSubscriptionElementInstanceKey = new DbLong();
    private final DbString messageSubscriptionMessageName = new DbString();
    private final DbCompositeKey<DbLong, DbString> messageSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.messageSubscriptionElementInstanceKey, (DbKey)this.messageSubscriptionMessageName);
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> messageSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> messageSubscriptionSentTimeColumnFamily;
    private final DbLong processSubscriptionSentTime;
    private final DbLong processSubscriptionElementInstanceKey;
    private final DbString processSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> processSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> processSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> processSubscriptionSentTimeColumnFamily;
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableColumnFamily;
    private final DbLong dbDecisionKey;
    private final PersistedDecision dbPersistedDecision;
    private final DbString dbDecisionId;
    private final DbForeignKey<DbLong> fkDecision;
    private final DbInt dbDecisionVersion;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionKeyAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbString dbDecisionRequirementsId;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersionColumnFamily;
    private final DbLong elementInstanceKey;
    private final ElementInstance elementInstance;
    private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> processInstanceKeyByProcessDefinitionKeyColumnFamily;
    private final DbForeignKey<DbLong> parentKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> parentChildKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> parentChildColumnFamily;
    private final DbString processIdKey;
    private final ColumnFamily<DbString, VersionInfo> processVersionInfoColumnFamily;
    private final DbProcessMigrationState processMigrationState;
    private final DbDecisionMigrationState decisionMigrationState;
    private final DbMessageMigrationState messageMigrationState;
    private final DbMessageStartEventSubscriptionMigrationState messageStartEventSubscriptionMigrationState;
    private final DbMessageSubscriptionMigrationState messageSubscriptionMigrationState;
    private final DbProcessMessageSubscriptionMigrationState processMessageSubscriptionMigrationState;
    private final DbJobMigrationState jobMigrationState;
    private final DbSignalSubscriptionMigrationState signalSubscriptionMigrationState;
    private final DbColumnFamilyCorrectionMigrationState columnFamilyCorrectionMigrationState;

    public DbMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageSubscriptionSentTime = new DbLong();
        this.messageSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.messageSubscriptionSentTime, this.messageSubscriptionElementKeyAndMessageName);
        this.messageSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.messageSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.processSubscriptionElementInstanceKey = new DbLong();
        this.processSubscriptionMessageName = new DbString();
        this.processSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.processSubscriptionElementInstanceKey, (DbKey)this.processSubscriptionMessageName);
        this.processSubscriptionSentTime = new DbLong();
        this.processSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.processSubscriptionSentTime, this.processSubscriptionElementKeyAndMessageName);
        this.processSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.processSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        DbLong temporaryVariablesKeyInstance = new DbLong();
        TemporaryVariables temporaryVariablesValue = new TemporaryVariables();
        this.temporaryVariableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, (DbKey)temporaryVariablesKeyInstance, (DbValue)temporaryVariablesValue);
        this.dbDecisionKey = new DbLong();
        this.dbPersistedDecision = new PersistedDecision();
        this.decisionsByKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISIONS, transactionContext, (DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.fkDecision = new DbForeignKey((DbKey)this.dbDecisionKey, (Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISIONS);
        this.dbDecisionVersion = new DbInt();
        this.decisionKeyAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.decisionKeyAndVersion, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey((DbKey)this.dbDecisionRequirementsKey, (Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS, transactionContext, (DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.dbDecisionRequirementsId = new DbString();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
        this.decisionRequirementsKeyByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.elementInstanceKey = new DbLong();
        this.elementInstance = new ElementInstance();
        this.elementInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.elementInstance);
        this.processDefinitionKey = new DbLong();
        this.processInstanceKeyByProcessDefinitionKey = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.elementInstanceKey);
        this.processInstanceKeyByProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY, transactionContext, this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
        this.parentKey = new DbForeignKey((DbKey)new DbLong(), (Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
        this.parentChildKey = new DbCompositeKey(this.parentKey, (DbKey)new DbForeignKey((DbKey)this.elementInstanceKey, (Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY));
        this.parentChildColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, (DbValue)DbNil.INSTANCE);
        this.processIdKey = new DbString();
        this.processVersionInfoColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_VERSION, transactionContext, (DbKey)this.processIdKey, (DbValue)new VersionInfo());
        this.processMigrationState = new DbProcessMigrationState(zeebeDb, transactionContext);
        this.decisionMigrationState = new DbDecisionMigrationState(zeebeDb, transactionContext);
        this.messageMigrationState = new DbMessageMigrationState(zeebeDb, transactionContext);
        this.messageStartEventSubscriptionMigrationState = new DbMessageStartEventSubscriptionMigrationState(zeebeDb, transactionContext);
        this.messageSubscriptionMigrationState = new DbMessageSubscriptionMigrationState(zeebeDb, transactionContext);
        this.processMessageSubscriptionMigrationState = new DbProcessMessageSubscriptionMigrationState(zeebeDb, transactionContext);
        this.jobMigrationState = new DbJobMigrationState(zeebeDb, transactionContext);
        this.signalSubscriptionMigrationState = new DbSignalSubscriptionMigrationState(zeebeDb, transactionContext);
        this.columnFamilyCorrectionMigrationState = new DbColumnFamilyCorrectionMigrationState(zeebeDb, transactionContext);
    }

    @Override
    public void migrateMessageSubscriptionSentTime(MutableMessageSubscriptionState messageSubscriptionState, PendingMessageSubscriptionState transientState) {
        this.messageSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            MessageSubscription messageSubscription = messageSubscriptionState.get(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (messageSubscription != null) {
                messageSubscriptionState.updateToCorrelatingState(messageSubscription.getRecord());
                transientState.onSent(elementInstanceKey, BufferUtil.bufferAsString((DirectBuffer)messageName), "<default>", sentTime);
            }
            this.messageSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateProcessMessageSubscriptionSentTime(MutableProcessMessageSubscriptionState persistentState, PendingProcessMessageSubscriptionState transientState) {
        this.processSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            ProcessMessageSubscription processMessageSubscription = persistentState.getSubscription(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer(), "<default>");
            if (processMessageSubscription != null) {
                ProcessMessageSubscriptionRecord record = processMessageSubscription.getRecord();
                ProcessMessageSubscriptionRecord exclusiveCopy = new ProcessMessageSubscriptionRecord();
                exclusiveCopy.wrap(record);
                if (processMessageSubscription.isOpening()) {
                    persistentState.updateToOpeningState(exclusiveCopy);
                    transientState.onSent(exclusiveCopy, sentTime);
                } else if (processMessageSubscription.isClosing()) {
                    persistentState.updateToClosingState(exclusiveCopy);
                    transientState.onSent(exclusiveCopy, sentTime);
                }
            }
            this.processSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateTemporaryVariables(MutableEventScopeInstanceState eventScopeInstanceState, MutableElementInstanceState elementInstanceState) {
        this.temporaryVariableColumnFamily.forEach((key, value) -> {
            long eventKey = -1L;
            String elementId = "migrated-variable-" + key.getValue();
            DirectBuffer elementIdBuffer = BufferUtil.wrapString((String)elementId);
            ElementInstance elementInstance = elementInstanceState.getInstance(key.getValue());
            if (elementInstance != null && elementInstance.getValue().getBpmnElementType().equals((Object)BpmnElementType.EVENT_SUB_PROCESS)) {
                long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
                eventScopeInstanceState.triggerStartEvent(flowScopeKey, -1L, elementIdBuffer, value.get(), elementInstance.getValue().getProcessInstanceKey());
                while (eventScopeInstanceState.pollEventTrigger(key.getValue()) != null) {
                }
            } else {
                eventScopeInstanceState.triggerStartEvent(key.getValue(), -1L, elementIdBuffer, value.get(), -1L);
            }
            this.temporaryVariableColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateDecisionsPopulateDecisionVersionByDecisionIdAndDecisionKey() {
        this.decisionsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionId.wrapBuffer(value.getDecisionId());
            this.dbDecisionKey.wrapLong(value.getDecisionKey());
            this.dbDecisionVersion.wrapInt(value.getVersion());
            this.decisionKeyByDecisionIdAndVersion.insert(this.decisionKeyAndVersion, this.fkDecision);
        });
    }

    @Override
    public void migrateDrgPopulateDrgVersionByDrgIdAndKey() {
        this.decisionRequirementsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionRequirementsId.wrapBuffer(value.getDecisionRequirementsId());
            this.dbDecisionRequirementsKey.wrapLong(value.getDecisionRequirementsKey());
            this.dbDecisionRequirementsVersion.wrapInt(value.getDecisionRequirementsVersion());
            this.decisionRequirementsKeyByIdAndVersionColumnFamily.insert(this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        });
    }

    @Override
    public void migrateElementInstancePopulateProcessInstanceByDefinitionKey() {
        ((DbLong)this.parentKey.inner()).wrapLong(-1L);
        this.parentChildColumnFamily.whileEqualPrefix(this.parentKey, (key, nil) -> {
            this.elementInstanceKey.wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            ElementInstance processInstance = (ElementInstance)this.elementInstanceColumnFamily.get((DbKey)this.elementInstanceKey);
            this.processDefinitionKey.wrapLong(processInstance.getValue().getProcessDefinitionKey());
            this.processInstanceKeyByProcessDefinitionKeyColumnFamily.upsert(this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
        });
    }

    @Override
    public void migrateProcessStateForMultiTenancy() {
        this.processMigrationState.migrateProcessStateForMultiTenancy();
    }

    @Override
    public void migrateDecisionStateForMultiTenancy() {
        this.decisionMigrationState.migrateDecisionStateForMultiTenancy();
    }

    @Override
    public void migrateMessageStateForMultiTenancy() {
        this.messageMigrationState.migrateMessageStateForMultiTenancy();
    }

    @Override
    public void migrateMessageStartEventSubscriptionForMultiTenancy() {
        this.messageStartEventSubscriptionMigrationState.migrateMessageStartEventSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateMessageEventSubscriptionForMultiTenancy() {
        this.messageSubscriptionMigrationState.migrateMessageSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateProcessMessageSubscriptionForMultiTenancy() {
        this.processMessageSubscriptionMigrationState.migrateProcessMessageSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateJobStateForMultiTenancy() {
        this.jobMigrationState.migrateJobStateForMultiTenancy();
    }

    @Override
    public void migrateSignalSubscriptionStateForMultiTenancy() {
        this.signalSubscriptionMigrationState.migrateSignalSubscriptionStateForMultiTenancy();
    }

    @Override
    public void correctColumnFamilyPrefix() {
        this.columnFamilyCorrectionMigrationState.correctColumnFamilyPrefix();
    }

    @Override
    public boolean shouldRunElementInstancePopulateProcessInstanceByDefinitionKey() {
        ((DbLong)this.parentKey.inner()).wrapLong(-1L);
        return this.processInstanceKeyByProcessDefinitionKeyColumnFamily.isEmpty() || this.processInstanceKeyByProcessDefinitionKeyColumnFamily.count() != this.parentChildColumnFamily.countEqualPrefix(this.parentKey);
    }
}

