/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum EngineMetricsDoc implements ExtendedMeterDocumentation
{
    CREATED_ROOT_PROCESS_INSTANCES{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.CREATION_MODE};

        public String getName() {
            return "zeebe.process.instance.creations.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of created (root) process instances";
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    ELEMENT_INSTANCE_EVENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ELEMENT_TYPE, EngineKeyNames.EVENT_TYPE};

        public String getDescription() {
            return "Number of process element instance events";
        }

        public String getName() {
            return "zeebe.element.instance.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    EXECUTED_EVENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ELEMENT_TYPE, EngineKeyNames.ORGANIZATION_ID};

        public String getDescription() {
            return "Number of executed (root) process instances";
        }

        public String getName() {
            return "zeebe.executed.instances.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    EVALUATED_DMN_ELEMENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ORGANIZATION_ID};

        public String getDescription() {
            return "Number of evaluated DMN elements including required decisions";
        }

        public String getName() {
            return "zeebe.evaluated.dmn.elements.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    BANNED_INSTANCES{

        public String getDescription() {
            return "Number of banned instances";
        }

        public String getName() {
            return "zeebe.banned.instances.total";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    BUFFERED_MESSAGES{

        public String getDescription() {
            return "Current number of buffered messages";
        }

        public String getName() {
            return "zeebe.buffered.messages.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    INCIDENT_EVENTS{

        public String getDescription() {
            return "Number of incident events";
        }

        public String getName() {
            return "zeebe.incidents.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{EngineKeyNames.INCIDENT_ACTION};
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    PENDING_INCIDENTS{

        public String getDescription() {
            return "Number of pending incidents";
        }

        public String getName() {
            return "zeebe.pending.incidents.total";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    JOB_EVENTS{

        public String getDescription() {
            return "Number of job events";
        }

        public String getName() {
            return "zeebe.job.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{EngineKeyNames.JOB_ACTION};
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    };


    public static enum JobAction {
        CREATED("created"),
        ACTIVATED("activated"),
        TIMED_OUT("timed out"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELED("canceled"),
        ERROR_THROWN("error thrown"),
        WORKERS_NOTIFIED("workers notified"),
        PUSHED("pushed");

        private final String label;

        private JobAction(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum IncidentAction {
        CREATED,
        RESOLVED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EngineAction {
        ACTIVATED,
        COMPLETED,
        TERMINATED,
        EVALUATED_SUCCESSFULLY,
        EVALUATED_FAILED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum CreationMode {
        CREATION_AT_DEFAULT_START_EVENT,
        CREATION_AT_GIVEN_ELEMENT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EngineKeyNames implements KeyName
    {
        CREATION_MODE{

            public String asString() {
                return "creation_mode";
            }
        }
        ,
        ACTION{

            public String asString() {
                return "action";
            }
        }
        ,
        INCIDENT_ACTION{

            public String asString() {
                return "action";
            }
        }
        ,
        ELEMENT_TYPE{

            public String asString() {
                return "type";
            }
        }
        ,
        EVENT_TYPE{

            public String asString() {
                return "eventType";
            }
        }
        ,
        JOB_ACTION{

            public String asString() {
                return "action";
            }
        }
        ,
        JOB_TYPE{

            public String asString() {
                return "type";
            }
        }
        ,
        ORGANIZATION_ID{

            public String asString() {
                return "organizationId";
            }
        };

    }
}

