/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.StatefulMeterRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicLong;

public final class IncidentMetrics {
    private final Counter incidentCreated;
    private final Counter incidentResolved;
    private final AtomicLong pendingIncidents;

    public IncidentMetrics(StatefulMeterRegistry meterRegistry) {
        this.pendingIncidents = meterRegistry.newLongGauge((ExtendedMeterDocumentation)EngineMetricsDoc.PENDING_INCIDENTS).state();
        this.incidentCreated = this.registerCounter(meterRegistry, EngineMetricsDoc.IncidentAction.CREATED);
        this.incidentResolved = this.registerCounter(meterRegistry, EngineMetricsDoc.IncidentAction.RESOLVED);
    }

    public void incidentCreated() {
        this.incidentCreated.increment();
        this.pendingIncidents.incrementAndGet();
    }

    public void incidentResolved() {
        this.incidentResolved.increment();
        this.pendingIncidents.decrementAndGet();
    }

    private Counter registerCounter(StatefulMeterRegistry meterRegistry, EngineMetricsDoc.IncidentAction action) {
        return Counter.builder((String)EngineMetricsDoc.INCIDENT_EVENTS.getName()).description(EngineMetricsDoc.INCIDENT_EVENTS.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.INCIDENT_ACTION.asString(), action.toString()).register((MeterRegistry)meterRegistry);
    }
}

