/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.util.collection.Table;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class JobProcessingMetrics {
    private final Table<EngineMetricsDoc.JobAction, String, Counter> jobEvents = Table.simple();
    private final MeterRegistry registry;

    public JobProcessingMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void countJobEvent(EngineMetricsDoc.JobAction action, String type) {
        this.countJobEvent(action, type, 1);
    }

    public void countJobEvent(EngineMetricsDoc.JobAction action, String type, int amount) {
        ((Counter)this.jobEvents.computeIfAbsent((Object)action, (Object)type, this::registerJobEventCounter)).increment((double)amount);
    }

    private Counter registerJobEventCounter(EngineMetricsDoc.JobAction jobAction, String jobType) {
        return Counter.builder((String)EngineMetricsDoc.JOB_EVENTS.getName()).description(EngineMetricsDoc.JOB_EVENTS.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.JOB_ACTION.asString(), jobAction.getLabel()).tag(EngineMetricsDoc.EngineKeyNames.JOB_TYPE.asString(), jobType).register(this.registry);
    }
}

