/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import org.agrona.collections.MutableInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JobTimeoutChecker
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(JobTimeoutChecker.class);
    private boolean shouldReschedule = false;
    private long executionTimestamp = -1L;
    private JobState.DeadlineIndex startAtIndex = null;
    private final JobState state;
    private ReadonlyStreamProcessorContext processingContext;
    private final Duration pollingInterval;
    private final int batchLimit;

    public JobTimeoutChecker(JobState state, Duration pollingInterval, int batchLimit) {
        this.state = state;
        this.pollingInterval = pollingInterval;
        this.batchLimit = batchLimit;
    }

    public void schedule(Duration idleInterval) {
        if (this.shouldReschedule) {
            this.processingContext.getScheduleService().runAt(ActorClock.currentTimeMillis() + idleInterval.toMillis(), (Task)this);
        }
    }

    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        MutableInteger counter;
        JobState.DeadlineIndex lastVisitedIndex;
        LOG.trace("Job timeout checker running...");
        if (this.executionTimestamp == -1L) {
            this.executionTimestamp = ActorClock.currentTimeMillis();
        }
        if ((lastVisitedIndex = this.state.forEachTimedOutEntry(this.executionTimestamp, this.startAtIndex, (arg_0, arg_1) -> this.lambda$execute$0(counter = new MutableInteger(0), taskResultBuilder, arg_0, arg_1))) != null) {
            LOG.trace("Job timeout checker yielded early. Will reschedule immediately from {}", (Object)lastVisitedIndex);
            this.startAtIndex = lastVisitedIndex;
            this.schedule(Duration.ZERO);
        } else {
            this.executionTimestamp = -1L;
            this.startAtIndex = null;
            this.schedule(this.pollingInterval);
        }
        LOG.trace("{} timeout job commands appended to task result builder", (Object)counter.get());
        return taskResultBuilder.build();
    }

    public void setProcessingContext(ReadonlyStreamProcessorContext processingContext) {
        this.processingContext = processingContext;
    }

    public void setShouldReschedule(boolean shouldReschedule) {
        this.shouldReschedule = shouldReschedule;
    }

    private /* synthetic */ boolean lambda$execute$0(MutableInteger counter, TaskResultBuilder taskResultBuilder, Long key, JobRecord record) {
        if (counter.getAndIncrement() >= this.batchLimit) {
            return false;
        }
        return taskResultBuilder.appendCommandRecord(key.longValue(), (Intent)JobIntent.TIME_OUT, (UnifiedRecordValue)record);
    }
}

