/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.ScheduledTaskDbState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.RecordProcessorContext;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;

public class TypedRecordProcessorContextImpl
implements TypedRecordProcessorContext {
    private final int partitionId;
    private final ProcessingScheduleService scheduleService;
    private final ProcessingDbState processingState;
    private final ZeebeDb zeebeDb;
    private final Writers writers;
    private final InterPartitionCommandSender partitionCommandSender;
    private final EngineConfiguration config;
    private final TransientPendingSubscriptionState transientMessageSubscriptionState;
    private final TransientPendingSubscriptionState transientProcessMessageSubscriptionState;
    private final MeterRegistry meterRegistry;

    public TypedRecordProcessorContextImpl(RecordProcessorContext context, Writers writers, EngineConfiguration config) {
        this.partitionId = context.getPartitionId();
        this.scheduleService = context.getScheduleService();
        this.zeebeDb = context.getZeebeDb();
        this.transientMessageSubscriptionState = new TransientPendingSubscriptionState();
        this.transientProcessMessageSubscriptionState = new TransientPendingSubscriptionState();
        this.processingState = new ProcessingDbState(this.partitionId, (ZeebeDb<ZbColumnFamilies>)this.zeebeDb, context.getTransactionContext(), context.getKeyGenerator(), this.transientMessageSubscriptionState, this.transientProcessMessageSubscriptionState, config);
        this.writers = writers;
        this.partitionCommandSender = context.getPartitionCommandSender();
        this.config = config;
        this.meterRegistry = context.getMeterRegistry();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public MutableProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    public Writers getWriters() {
        return this.writers;
    }

    @Override
    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    @Override
    public Supplier<ScheduledTaskState> getScheduledTaskStateFactory() {
        return () -> new ScheduledTaskDbState((ZeebeDb<ZbColumnFamilies>)this.zeebeDb, this.zeebeDb.createContext(), this.partitionId, this.transientMessageSubscriptionState, this.transientProcessMessageSubscriptionState);
    }

    @Override
    public EngineConfiguration getConfig() {
        return this.config;
    }

    @Override
    public TransientPendingSubscriptionState getTransientProcessMessageSubscriptionState() {
        return this.transientProcessMessageSubscriptionState;
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }
}

