/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnSignalBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class IntermediateThrowEventProcessor
implements BpmnElementProcessor<ExecutableIntermediateThrowEvent> {
    private final List<IntermediateThrowEventBehavior> throwEventBehaviors = List.of(new NoneIntermediateThrowEventBehavior(), new MessageIntermediateThrowEventBehavior(), new LinkIntermediateThrowEventBehavior(), new EscalationIntermediateThrowEventBehavior(), new SignalIntermediateThrowEventBehavior(), new CompensationBehavior());
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final ExpressionProcessor expressionProcessor;
    private final BpmnSignalBehavior signalBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public IntermediateThrowEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.signalBehavior = bpmnBehaviors.signalBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableIntermediateThrowEvent> getType() {
        return ExecutableIntermediateThrowEvent.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
        return this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
        return this.eventBehaviorOf(element).onComplete(element, completing);
    }

    @Override
    public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
        this.eventBehaviorOf(element).onTerminate(element, terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating, element.getEventType());
        this.incidentBehavior.resolveIncidents(terminated);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private IntermediateThrowEventBehavior eventBehaviorOf(ExecutableIntermediateThrowEvent element) {
        return this.throwEventBehaviors.stream().filter(behavior -> behavior.isSuitableForEvent(element)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This kind of intermediate throw event is not supported."));
    }

    private final class NoneIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private NoneIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isNoneThrowEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            return BpmnElementProcessor.SUCCESS;
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private final class MessageIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private MessageIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isMessageThrowEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            return element.getJobWorkerProperties() == null ? BpmnElementProcessor.SUCCESS : IntermediateThrowEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> IntermediateThrowEventProcessor.this.jobBehavior.evaluateJobExpressions(element.getJobWorkerProperties(), activating)).thenDo(jobProperties -> {
                IntermediateThrowEventProcessor.this.jobBehavior.createNewJob(activating, element, (BpmnJobBehavior.JobProperties)jobProperties);
                IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }

        @Override
        public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
            if (element.getJobWorkerProperties() != null) {
                IntermediateThrowEventProcessor.this.jobBehavior.cancelJob(terminating);
            }
        }
    }

    private final class LinkIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private LinkIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isLinkThrowEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            return BpmnElementProcessor.SUCCESS;
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            ExecutableLink link = element.getLink();
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.activateElementInstanceInFlowScope((BpmnElementContext)completed, link.getCatchEventElement()));
        }
    }

    private final class EscalationIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private EscalationIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isEscalationThrowEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            return this.evaluateEscalationCode(element, activating).thenDo(escalationCode -> {
                BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
                boolean canBeCompleted = IntermediateThrowEventProcessor.this.eventPublicationBehavior.throwEscalationEvent(element.getId(), (DirectBuffer)escalationCode, activated);
                if (canBeCompleted) {
                    IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
                }
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }

        private Either<Failure, DirectBuffer> evaluateEscalationCode(ExecutableIntermediateThrowEvent element, BpmnElementContext context) {
            ExecutableEscalation escalation = element.getEscalation();
            EnsureUtil.ensureNotNull((String)"escalation", (Object)escalation);
            if (escalation.getEscalationCode().isPresent()) {
                return Either.right((Object)escalation.getEscalationCode().get());
            }
            return IntermediateThrowEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(escalation.getEscalationCodeExpression(), context.getElementInstanceKey());
        }
    }

    private final class SignalIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private SignalIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isSignalThrowEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> IntermediateThrowEventProcessor.this.signalBehavior.broadcastNewSignal(activating, element.getSignal())).thenDo(ok -> {
                BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
                IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private final class CompensationBehavior
    implements IntermediateThrowEventBehavior {
        private CompensationBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isCompensationEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            boolean isCompensationTriggered;
            BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            ExecutableCompensation compensation = element.getCompensation();
            boolean bl = isCompensationTriggered = compensation.hasReferenceActivity() ? IntermediateThrowEventProcessor.this.compensationSubscriptionBehaviour.triggerCompensationForActivity(element, compensation.getReferenceCompensationActivity(), activated) : IntermediateThrowEventProcessor.this.compensationSubscriptionBehaviour.triggerCompensation(element, activating);
            if (isCompensationTriggered) {
                return BpmnElementProcessor.SUCCESS;
            }
            BpmnElementContext completing = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleting(activated);
            return this.onComplete(element, completing);
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private static interface IntermediateThrowEventBehavior {
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent var1);

        public Either<Failure, ?> onActivate(ExecutableIntermediateThrowEvent var1, BpmnElementContext var2);

        default public Either<Failure, ?> onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            return BpmnElementProcessor.SUCCESS;
        }

        default public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
        }
    }
}

