/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobVariablesCollector;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.collections.MutableReference;
import org.agrona.collections.ObjectHashSet;

final class JobBatchCollector {
    private final ObjectHashSet<DirectBuffer> variableNames = new ObjectHashSet();
    private final JobState jobState;
    private final JobVariablesCollector jobVariablesCollector;
    private final Predicate<Integer> canWriteEventOfLength;

    JobBatchCollector(JobState jobState, VariableState variableState, Predicate<Integer> canWriteEventOfLength) {
        this.jobState = jobState;
        this.canWriteEventOfLength = canWriteEventOfLength;
        this.jobVariablesCollector = new JobVariablesCollector(variableState);
    }

    Either<TooLargeJob, Integer> collectJobs(TypedRecord<JobBatchRecord> record) {
        JobBatchRecord value = (JobBatchRecord)record.getValue();
        ValueArray jobIterator = value.jobs();
        ValueArray jobKeyIterator = value.jobKeys();
        Collection<DirectBuffer> requestedVariables = this.collectVariableNames(value);
        int maxActivatedCount = value.getMaxJobsToActivate();
        MutableInteger activatedCount = new MutableInteger(0);
        MutableReference unwritableJob = new MutableReference();
        List tenantIds = value.getTenantIds().isEmpty() ? List.of("<default>") : value.getTenantIds();
        this.jobState.forEachActivatableJobs(value.getTypeBuffer(), tenantIds, (key, jobRecord) -> {
            long deadline = record.getTimestamp() + value.getTimeout();
            jobRecord.setDeadline(deadline).setWorker(value.getWorkerBuffer());
            this.jobVariablesCollector.setJobVariables(requestedVariables, (JobRecord)jobRecord);
            int jobRecordLength = jobRecord.getLength();
            int expectedEventLength = record.getLength() + jobRecordLength + 8192;
            if (activatedCount.value > maxActivatedCount || !this.canWriteEventOfLength.test(expectedEventLength)) {
                if (activatedCount.value == 0) {
                    unwritableJob.set((Object)new TooLargeJob((long)key, (JobRecord)jobRecord, expectedEventLength));
                }
                value.setTruncated(true);
                return false;
            }
            this.appendJobToBatch((ValueArray<JobRecord>)jobIterator, (ValueArray<LongValue>)jobKeyIterator, (long)key, (JobRecord)jobRecord);
            activatedCount.increment();
            return activatedCount.value < maxActivatedCount;
        });
        if (unwritableJob.ref != null) {
            return Either.left((Object)((TooLargeJob)unwritableJob.ref));
        }
        return Either.right((Object)activatedCount.value);
    }

    private void appendJobToBatch(ValueArray<JobRecord> jobIterator, ValueArray<LongValue> jobKeyIterator, long key, JobRecord jobRecord) {
        ((LongValue)jobKeyIterator.add()).setValue(key);
        ((JobRecord)jobIterator.add()).copyFrom((BufferWriter)jobRecord);
    }

    private Collection<DirectBuffer> collectVariableNames(JobBatchRecord batchRecord) {
        ValueArray requestedVariables = batchRecord.variables();
        this.variableNames.clear();
        requestedVariables.forEach(variable -> this.variableNames.add((Object)BufferUtil.cloneBuffer((DirectBuffer)variable.getValue())));
        return this.variableNames;
    }

    record TooLargeJob(long key, JobRecord jobRecord, int expectedEventLength) {
    }
}

