/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.JobKind;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class JobCompleteProcessor
implements CommandProcessor<JobRecord> {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to update retries for job with key '%d', but no such job was found";
    private final JobState jobState;
    private final ElementInstanceState elementInstanceState;
    private final DefaultJobCommandPreconditionGuard defaultProcessor;
    private final JobMetrics jobMetrics;
    private final EventHandle eventHandle;

    public JobCompleteProcessor(ProcessingState state, JobMetrics jobMetrics, EventHandle eventHandle) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("complete", this.jobState, this::acceptCommand);
        this.jobMetrics = jobMetrics;
        this.eventHandle = eventHandle;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, JobRecord value) {
        long serviceTaskKey = value.getElementInstanceKey();
        ElementInstance serviceTask = this.elementInstanceState.getInstance(serviceTaskKey);
        if (serviceTask != null) {
            if (value.getJobKind() == JobKind.EXECUTION_LISTENER) {
                this.eventHandle.triggeringProcessEvent(value);
                commandWriter.appendFollowUpCommand(serviceTaskKey, (Intent)ProcessInstanceIntent.COMPLETE_EXECUTION_LISTENER, (RecordValue)serviceTask.getValue());
                return;
            }
            long scopeKey = serviceTask.getValue().getFlowScopeKey();
            ElementInstance scopeInstance = this.elementInstanceState.getInstance(scopeKey);
            if (scopeInstance != null && scopeInstance.isActive()) {
                this.eventHandle.triggeringProcessEvent(value);
                commandWriter.appendFollowUpCommand(serviceTaskKey, (Intent)ProcessInstanceIntent.COMPLETE_ELEMENT, (RecordValue)serviceTask.getValue());
            }
        }
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey, command.getAuthorizations());
        if (job == null) {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, jobKey));
            return;
        }
        job.setVariables(((JobRecord)command.getValue()).getVariablesBuffer());
        commandControl.accept((Intent)JobIntent.COMPLETED, job);
        this.jobMetrics.jobCompleted(job.getType());
    }
}

