/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public class UserTaskCommandPreconditionChecker {
    private static final String NO_USER_TASK_FOUND_MESSAGE = "Expected to %s user task with key '%d', but no such user task was found";
    private static final String INVALID_USER_TASK_STATE_MESSAGE = "Expected to %s user task with key '%d', but it is in state '%s'";
    private static final String CLAIM_INTENT = "claim";
    private final List<UserTaskState.LifecycleState> validLifecycleStates;
    private final String intent;
    private final BiFunction<TypedRecord<UserTaskRecord>, UserTaskRecord, Either<Tuple<RejectionType, String>, UserTaskRecord>> additionalChecks;
    private final UserTaskState userTaskState;

    public UserTaskCommandPreconditionChecker(List<UserTaskState.LifecycleState> validLifecycleStates, String intent, UserTaskState userTaskState) {
        this.validLifecycleStates = validLifecycleStates;
        this.intent = intent;
        this.additionalChecks = null;
        this.userTaskState = userTaskState;
    }

    public UserTaskCommandPreconditionChecker(List<UserTaskState.LifecycleState> validLifecycleStates, String intent, BiFunction<TypedRecord<UserTaskRecord>, UserTaskRecord, Either<Tuple<RejectionType, String>, UserTaskRecord>> additionalChecks, UserTaskState userTaskState) {
        this.validLifecycleStates = validLifecycleStates;
        this.intent = intent;
        this.additionalChecks = additionalChecks;
        this.userTaskState = userTaskState;
    }

    protected Either<Tuple<RejectionType, String>, UserTaskRecord> check(TypedRecord<UserTaskRecord> command) {
        long userTaskKey = command.getKey();
        UserTaskRecord persistedRecord = this.userTaskState.getUserTask(userTaskKey, command.getAuthorizations());
        if (persistedRecord == null) {
            return Either.left((Object)Tuple.of((Object)RejectionType.NOT_FOUND, (Object)String.format(NO_USER_TASK_FOUND_MESSAGE, this.intent, userTaskKey)));
        }
        UserTaskState.LifecycleState lifecycleState = this.userTaskState.getLifecycleState(userTaskKey);
        if (!this.validLifecycleStates.contains((Object)lifecycleState)) {
            return Either.left((Object)Tuple.of((Object)RejectionType.INVALID_STATE, (Object)String.format(INVALID_USER_TASK_STATE_MESSAGE, new Object[]{this.intent, userTaskKey, lifecycleState})));
        }
        return Optional.ofNullable(this.additionalChecks).map(checks -> (Either)checks.apply(command, persistedRecord)).filter(Either::isLeft).orElse(Either.right((Object)persistedRecord));
    }
}

