/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnSignalBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCompensation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public final class EndEventProcessor
implements BpmnElementProcessor<ExecutableEndEvent> {
    private final List<EndEventBehavior> endEventBehaviors = List.of(new NoneEndEventBehavior(), new ErrorEndEventBehavior(), new MessageEndEventBehavior(), new TerminateEndEventBehavior(), new EscalationEndEventBehavior(), new SignalEndEventBehavior(), new CompensationBehaviour());
    private final ExpressionProcessor expressionProcessor;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnSignalBehavior signalBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public EndEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.signalBehavior = bpmnBehaviors.signalBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableEndEvent> getType() {
        return ExecutableEndEvent.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
        return this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
        return this.eventBehaviorOf(element).finalizeActivation(element, activating);
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext context) {
        return this.eventBehaviorOf(element).onComplete(element, context);
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext context) {
        return this.eventBehaviorOf(element).finalizeCompletion(element, context);
    }

    @Override
    public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        this.eventBehaviorOf(element).onTerminate(element, terminating);
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(terminating);
        }
        this.incidentBehavior.resolveIncidents(terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating, element.getEventType());
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private EndEventBehavior eventBehaviorOf(ExecutableEndEvent element) {
        return this.endEventBehaviors.stream().filter(behavior -> behavior.isSuitableForEvent(element)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This kind of end event is not supported."));
    }

    private final class NoneEndEventBehavior
    implements EndEventBehavior {
        private NoneEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isNoneEndEvent();
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            return BpmnElementProcessor.SUCCESS;
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element);
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private final class ErrorEndEventBehavior
    implements EndEventBehavior {
        private ErrorEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isErrorEndEvent();
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            return this.evaluateErrorCode(element, activating).flatMap(errorCode -> EndEventProcessor.this.eventPublicationBehavior.findErrorCatchEvent((DirectBuffer)errorCode, activating)).thenDo(catchEvent -> {
                EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
                EndEventProcessor.this.eventPublicationBehavior.throwErrorEvent((CatchEventAnalyzer.CatchEventTuple)catchEvent);
            });
        }

        private Either<Failure, DirectBuffer> evaluateErrorCode(ExecutableEndEvent element, BpmnElementContext context) {
            ExecutableError error = element.getError();
            EnsureUtil.ensureNotNull((String)"error", (Object)error);
            if (error.getErrorCode().isPresent()) {
                return Either.right((Object)error.getErrorCode().get());
            }
            return EndEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(error.getErrorCodeExpression(), context.getElementInstanceKey());
        }
    }

    private final class MessageEndEventBehavior
    implements EndEventBehavior {
        private MessageEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isMessageEndEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            return EndEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element);
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            return EndEventProcessor.this.jobBehavior.evaluateJobExpressions(element.getJobWorkerProperties(), activating).thenDo(jobProperties -> {
                EndEventProcessor.this.jobBehavior.createNewJob(activating, element, (BpmnJobBehavior.JobProperties)jobProperties);
                EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element);
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }

        @Override
        public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
            EndEventProcessor.this.jobBehavior.cancelJob(terminating);
        }
    }

    private final class TerminateEndEventBehavior
    implements EndEventBehavior {
        private TerminateEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isTerminateEndEvent();
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            return BpmnElementProcessor.SUCCESS;
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> {
                BpmnElementContext flowScopeContext = EndEventProcessor.this.stateBehavior.getFlowScopeContext((BpmnElementContext)completed);
                EndEventProcessor.this.stateTransitionBehavior.terminateChildInstances(flowScopeContext);
            });
        }
    }

    private final class EscalationEndEventBehavior
    implements EndEventBehavior {
        private EscalationEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isEscalationEndEvent();
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            return this.evaluateEscalationCode(element, activating).thenDo(escalationCode -> {
                BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
                boolean canBeCompleted = EndEventProcessor.this.eventPublicationBehavior.throwEscalationEvent(element.getId(), (DirectBuffer)escalationCode, activated);
                if (canBeCompleted) {
                    EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
                }
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element);
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }

        private Either<Failure, DirectBuffer> evaluateEscalationCode(ExecutableEndEvent element, BpmnElementContext context) {
            ExecutableEscalation escalation = element.getEscalation();
            EnsureUtil.ensureNotNull((String)"escalation", (Object)escalation);
            if (escalation.getEscalationCode().isPresent()) {
                return Either.right((Object)escalation.getEscalationCode().get());
            }
            return EndEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(escalation.getEscalationCodeExpression(), context.getElementInstanceKey());
        }
    }

    private final class SignalEndEventBehavior
    implements EndEventBehavior {
        private SignalEndEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isSignalEndEvent();
        }

        @Override
        public Either<Failure, ?> onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            return EndEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element);
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            return EndEventProcessor.this.signalBehavior.broadcastNewSignal(activating, element.getSignal()).thenDo(ok -> {
                BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
                EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            });
        }

        @Override
        public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element);
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private final class CompensationBehaviour
    implements EndEventBehavior {
        private CompensationBehaviour() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableEndEvent element) {
            return element.isCompensationEvent();
        }

        @Override
        public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            boolean isCompensationTriggered;
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            ExecutableCompensation compensation = element.getCompensation();
            boolean bl = isCompensationTriggered = compensation.hasReferenceActivity() ? EndEventProcessor.this.compensationSubscriptionBehaviour.triggerCompensationForActivity(element, compensation.getReferenceCompensationActivity(), activated) : EndEventProcessor.this.compensationSubscriptionBehaviour.triggerCompensation(element, activating);
            if (isCompensationTriggered) {
                return BpmnElementProcessor.SUCCESS;
            }
            EndEventProcessor.this.stateTransitionBehavior.completeElement(activated);
            return BpmnElementProcessor.SUCCESS;
        }

        @Override
        public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
        }
    }

    private static interface EndEventBehavior {
        public boolean isSuitableForEvent(ExecutableEndEvent var1);

        default public Either<Failure, ?> onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            return BpmnElementProcessor.SUCCESS;
        }

        default public Either<Failure, ?> finalizeActivation(ExecutableEndEvent element, BpmnElementContext activating) {
            return BpmnElementProcessor.SUCCESS;
        }

        default public Either<Failure, ?> onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            return BpmnElementProcessor.SUCCESS;
        }

        default public Either<Failure, ?> finalizeCompletion(ExecutableEndEvent element, BpmnElementContext completing) {
            return BpmnElementProcessor.SUCCESS;
        }

        default public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        }
    }
}

