/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class PersistedForm
extends UnpackedObject
implements DbValue {
    private final StringProperty formIdProp = new StringProperty("formId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty formKeyProp = new LongProperty("formKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty resourceProp = new BinaryProperty("resource", (DirectBuffer)new UnsafeBuffer());
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", (DirectBuffer)new UnsafeBuffer());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty deploymentKeyProp = new LongProperty("deploymentKey", -1L);
    private final StringProperty versionTagProp = new StringProperty("versionTag", "");

    public PersistedForm() {
        super(9);
        this.declareProperty((BaseProperty)this.formIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.formKeyProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.resourceProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.deploymentKeyProp).declareProperty((BaseProperty)this.versionTagProp);
    }

    public PersistedForm copy() {
        PersistedForm copy = new PersistedForm();
        copy.formIdProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getFormId()));
        copy.versionProp.setValue(this.getVersion());
        copy.formKeyProp.setValue(this.getFormKey());
        copy.resourceNameProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getResourceName()));
        copy.resourceProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getResource()));
        copy.checksumProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getChecksum()));
        copy.tenantIdProp.setValue(this.getTenantId());
        copy.deploymentKeyProp.setValue(this.getDeploymentKey());
        copy.versionTagProp.setValue(this.getVersionTag());
        return copy;
    }

    public DirectBuffer getFormId() {
        return this.formIdProp.getValue();
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public String getVersionTag() {
        return BufferUtil.bufferAsString((DirectBuffer)this.versionTagProp.getValue());
    }

    public long getFormKey() {
        return this.formKeyProp.getValue();
    }

    public DirectBuffer getResourceName() {
        return this.resourceNameProp.getValue();
    }

    public DirectBuffer getResource() {
        return this.resourceProp.getValue();
    }

    public DirectBuffer getChecksum() {
        return this.checksumProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public long getDeploymentKey() {
        return this.deploymentKeyProp.getValue();
    }

    public void wrap(FormRecord record) {
        this.formIdProp.setValue(record.getFormId());
        this.versionProp.setValue(record.getVersion());
        this.formKeyProp.setValue(record.getFormKey());
        this.resourceNameProp.setValue(record.getResourceNameBuffer());
        this.resourceProp.setValue((DirectBuffer)BufferUtil.wrapArray((byte[])record.getResource()));
        this.checksumProp.setValue(record.getChecksumBuffer());
        this.tenantIdProp.setValue(record.getTenantId());
        this.deploymentKeyProp.setValue(record.getDeploymentKey());
        this.versionTagProp.setValue(record.getVersionTag());
    }
}

