/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.util.Either;

public class UndefinedTaskProcessor
implements BpmnElementProcessor<ExecutableActivity> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;
    private final BpmnJobBehavior jobBehavior;

    public UndefinedTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableActivity> getType() {
        return ExecutableActivity.class;
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableActivity element, BpmnElementContext context) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
        this.stateTransitionBehavior.completeElement(activated);
        return SUCCESS;
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableActivity element, BpmnElementContext context) {
        this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableActivity element, BpmnElementContext context) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(context);
        }
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

