/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableAuthorizationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableUserState;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.intent.UserIntent;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;

public class UserCreatedApplier
implements TypedEventApplier<UserIntent, UserRecord> {
    private final MutableUserState userState;
    private final MutableAuthorizationState authorizationState;

    public UserCreatedApplier(MutableProcessingState processingState) {
        this.userState = processingState.getUserState();
        this.authorizationState = processingState.getAuthorizationState();
    }

    @Override
    public void applyState(long key, UserRecord value) {
        this.userState.create(key, value);
        this.authorizationState.insertOwnerTypeByKey(key, AuthorizationOwnerType.USER);
    }
}

