/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class BpmnStateBehavior {
    private final ElementInstanceState elementInstanceState;
    private final VariableState variablesState;
    private final JobState jobState;
    private final ProcessState processState;
    private final VariableBehavior variableBehavior;

    public BpmnStateBehavior(ProcessingState processingState, VariableBehavior variableBehavior) {
        this.variableBehavior = variableBehavior;
        this.processState = processingState.getProcessState();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.variablesState = processingState.getVariableState();
        this.jobState = processingState.getJobState();
    }

    public ElementInstance getElementInstance(BpmnElementContext context) {
        return this.getElementInstance(context.getElementInstanceKey());
    }

    public ElementInstance getElementInstance(long elementInstanceKey) {
        return this.elementInstanceState.getInstance(elementInstanceKey);
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public boolean canBeTerminated(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.getFlowScopeInstance(context);
        if (flowScopeInstance == null) {
            return false;
        }
        long activePaths = flowScopeInstance.getNumberOfActiveElementInstances();
        if (activePaths < 0L) {
            throw new BpmnProcessingException(context, String.format("Expected number of active paths to be positive but got %d for instance %s", new Object[]{activePaths, flowScopeInstance}));
        }
        return activePaths == 0L;
    }

    public boolean canBeCompleted(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.getFlowScopeInstance(context);
        if (flowScopeInstance == null) {
            return false;
        }
        long activePaths = (long)flowScopeInstance.getNumberOfActiveElementInstances() + flowScopeInstance.getActiveSequenceFlows();
        if (activePaths < 0L) {
            throw new BpmnProcessingException(context, String.format("Expected number of active paths to be positive but got %d for instance %s", new Object[]{activePaths, flowScopeInstance}));
        }
        return activePaths == 0L;
    }

    public ElementInstance getFlowScopeInstance(BpmnElementContext context) {
        return this.elementInstanceState.getInstance(context.getFlowScopeKey());
    }

    public List<BpmnElementContext> getChildInstanceContexts(BpmnElementContext context) {
        return this.elementInstanceState.getChildren(context.getElementInstanceKey()).stream().map(childInstance -> context.copy(childInstance.getKey(), childInstance.getValue(), childInstance.getState())).collect(Collectors.toList());
    }

    public Set<DirectBuffer> getTakenSequenceFlowIds(BpmnElementContext context) {
        return this.elementInstanceState.getTakenSequenceFlows(context.getFlowScopeKey(), context.getElementId());
    }

    public BpmnElementContext getFlowScopeContext(BpmnElementContext context) {
        ElementInstance flowScope = this.getFlowScopeInstance(context);
        return context.copy(flowScope.getKey(), flowScope.getValue(), flowScope.getState());
    }

    public BpmnElementContext getParentElementInstanceContext(BpmnElementContext context) {
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(context.getParentElementInstanceKey());
        return context.copy(parentElementInstance.getKey(), parentElementInstance.getValue(), parentElementInstance.getState());
    }

    public Optional<DeployedProcess> getProcess(long processDefinitionKey, String tenantId) {
        return Optional.ofNullable(this.processState.getProcessByKeyAndTenant(processDefinitionKey, tenantId));
    }

    public Optional<DeployedProcess> getLatestProcessVersion(DirectBuffer processId, String tenantId) {
        DeployedProcess process = this.processState.getLatestProcessVersionByProcessId(processId, tenantId);
        return Optional.ofNullable(process);
    }

    public Optional<DeployedProcess> getProcessByProcessIdAndDeploymentKey(DirectBuffer processId, long deploymentKey, String tenantId) {
        DeployedProcess process = this.processState.getProcessByProcessIdAndDeploymentKey(processId, deploymentKey, tenantId);
        return Optional.ofNullable(process);
    }

    public Optional<DeployedProcess> getProcessByProcessIdAndVersionTag(DirectBuffer processId, String versionTag, String tenantId) {
        DeployedProcess process = this.processState.getProcessByProcessIdAndVersionTag(processId, versionTag, tenantId);
        return Optional.ofNullable(process);
    }

    public Either<Failure, Long> getDeploymentKey(long processDefinitionKey, String tenantId) {
        return this.getProcess(processDefinitionKey, tenantId).map(DeployedProcess::getDeploymentKey).map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to find deployment key for process definition key %s and tenant %s, but not found.", processDefinitionKey, tenantId))));
    }

    public Optional<ElementInstance> getCalledChildInstance(BpmnElementContext context) {
        ElementInstance elementInstance = this.getElementInstance(context);
        long calledChildInstanceKey = elementInstance.getCalledChildInstanceKey();
        return Optional.ofNullable(this.elementInstanceState.getInstance(calledChildInstanceKey));
    }

    public DirectBuffer getLocalVariable(BpmnElementContext context, DirectBuffer variableName) {
        return this.variablesState.getVariableLocal(context.getElementInstanceKey(), variableName);
    }

    public void setLocalVariable(BpmnElementContext context, DirectBuffer variableName, DirectBuffer variableValue) {
        this.setLocalVariable(context, variableName, variableValue, 0, variableValue.capacity());
    }

    public void setLocalVariable(BpmnElementContext context, DirectBuffer variableName, DirectBuffer variableValue, int valueOffset, int valueLength) {
        this.variableBehavior.setLocalVariable(context.getElementInstanceKey(), context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getBpmnProcessId(), context.getTenantId(), variableName, variableValue, valueOffset, valueLength);
    }

    public void propagateVariable(BpmnElementContext context, DirectBuffer variableName) {
        long sourceScope = context.getElementInstanceKey();
        long targetScope = context.getFlowScopeKey();
        DirectBuffer variablesAsDocument = this.variablesState.getVariablesAsDocument(sourceScope, List.of(variableName));
        this.variableBehavior.mergeDocument(targetScope, context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getBpmnProcessId(), context.getTenantId(), variablesAsDocument);
    }

    public void copyAllVariablesToProcessInstance(long sourceScopeKey, long targetProcessInstanceKey, DeployedProcess targetProcess) {
        DirectBuffer variables = this.variablesState.getVariablesAsDocument(sourceScopeKey);
        this.copyVariablesToProcessInstance(targetProcessInstanceKey, targetProcess, variables);
    }

    public void copyLocalVariablesToProcessInstance(long sourceScopeKey, long targetProcessInstanceKey, DeployedProcess targetProcess) {
        DirectBuffer variables = this.variablesState.getVariablesLocalAsDocument(sourceScopeKey);
        this.copyVariablesToProcessInstance(targetProcessInstanceKey, targetProcess, variables);
    }

    private void copyVariablesToProcessInstance(long targetProcessInstanceKey, DeployedProcess targetProcess, DirectBuffer variables) {
        this.variableBehavior.mergeDocument(targetProcessInstanceKey, targetProcess.getKey(), targetProcessInstanceKey, targetProcess.getBpmnProcessId(), targetProcess.getTenantId(), variables);
    }

    public boolean isInterrupted(BpmnElementContext flowScopeContext) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(flowScopeContext.getElementInstanceKey());
        return flowScopeInstance.getNumberOfActiveElementInstances() == 0 && flowScopeInstance.isInterrupted() && flowScopeInstance.isActive();
    }

    public boolean isInterruptedByTerminateEndEvent(BpmnElementContext flowScopeContext, ElementInstance flowScopeInstance) {
        Optional<DeployedProcess> process = this.getProcess(flowScopeContext.getProcessDefinitionKey(), flowScopeContext.getTenantId());
        if (process.isEmpty() || !this.isInterrupted(flowScopeContext)) {
            return false;
        }
        AbstractFlowElement interruptingElement = process.get().getProcess().getElementById(flowScopeInstance.getInterruptingElementId());
        if (interruptingElement.getElementType().equals((Object)BpmnElementType.END_EVENT)) {
            return ((ExecutableEndEvent)interruptingElement).isTerminateEndEvent();
        }
        return false;
    }

    public int getNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId) {
        return this.elementInstanceState.getNumberOfTakenSequenceFlows(flowScopeKey, gatewayElementId);
    }
}

